/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal;

import com.atmel.avr32.target.FuseRegisterSettings;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetAction;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.ITargetModifiedListener;
import com.atmel.avr32.target.Target;
import com.atmel.avr32.target.TargetJob;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.internal.TargetManager;
import com.atmel.avr32.target.ui.TargetAction;
import com.atmel.avr32.target.ui.TargetTableLabelProvider;
import com.atmel.avr32.target.ui.internal.ListTargetsAction;
import com.atmel.avr32.target.ui.internal.Messages;
import java.io.IOException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TargetView
extends ViewPart
implements ITabbedPropertySheetPageContributor {
    public static final String MB_INTERNALS = "internals";
    private static final String VIEW_CONTEXT_ID = "com.atmel.avr32.views.contexts.targetView";
    private static final String VIEW_ID = "com.atmel.avr32.views.TargetPropertiesView";
    private ViewContentProvider provider;
    private ITargetAction ta_remove;
    private ITargetAction ta_default;
    private TableViewer tableView;
    private ListTargetsAction ta_List;
    private Action addTargetAction;
    private IContextActivation contextActivation;

    void performDragSetData(DragSourceEvent event) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            return;
        }
    }

    public void createPartControl(Composite parent) {
        this.provider = new ViewContentProvider();
        this.tableView = new TableViewer(parent, 66306);
        this.tableView.setContentProvider((IContentProvider)this.provider);
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        this.contextActivation = contextService.activateContext(VIEW_CONTEXT_ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.atmel.avr32.doc.guide.avr32target");
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableView);
        TargetManager.getDefault().addTargetModifiedListener(this.provider);
        TableColumn column0 = new TableColumn(this.tableView.getTable(), 16384);
        column0.setText("");
        column0.setWidth(30);
        column0.setMoveable(false);
        TableColumn column1 = new TableColumn(this.tableView.getTable(), 16384);
        column1.setText(Messages.TargetsView_Column_Name);
        column1.setWidth(100);
        column1.setMoveable(false);
        column1.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(1));
        TableColumn column2 = new TableColumn(this.tableView.getTable(), 16384);
        column2.setText(Messages.TargetsView_Column_Adapter);
        column2.setWidth(100);
        column2.setMoveable(false);
        column2.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(2));
        TableColumn column3 = new TableColumn(this.tableView.getTable(), 16384);
        column3.setText(Messages.TargetsView_Column_Board);
        column3.setWidth(100);
        column3.setMoveable(false);
        column3.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(3));
        TableColumn column4 = new TableColumn(this.tableView.getTable(), 16384);
        column4.setText(Messages.TargetsView_Column_CPU);
        column4.setWidth(50);
        column4.setMoveable(false);
        column4.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(4));
        this.tableView.getTable().setHeaderVisible(true);
        this.tableView.setLabelProvider((IBaseLabelProvider)new TargetTableLabelProvider());
        this.tableView.setInput((Object)this.getSite());
        this.addDragAndDropSupport();
        final Table table = this.tableView.getTable();
        table.setToolTipText("");
        final Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                Label label = (Label)event.widget;
                Shell shell = label.getShell();
                switch (event.type) {
                    case 3: {
                        Event e = new Event();
                        e.item = (TableItem)label.getData("_TABLEITEM");
                        table.setSelection(new TableItem[]{(TableItem)e.item});
                        table.notifyListeners(13, e);
                        shell.dispose();
                        table.setFocus();
                        break;
                    }
                    case 7: {
                        shell.dispose();
                    }
                }
            }
        };
        Listener tableListener = new Listener(){
            Shell tip = null;
            Label label = null;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: 
                    case 5: 
                    case 12: {
                        if (this.tip == null) break;
                        this.tip.dispose();
                        this.tip = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        TableItem item = table.getItem(new Point(event.x, event.y));
                        if (item == null) break;
                        if (this.tip != null && !this.tip.isDisposed()) {
                            this.tip.dispose();
                        }
                        Display display = Display.getCurrent();
                        Shell shell = display.getActiveShell();
                        this.tip = new Shell(shell, 540676);
                        this.tip.setBackground(display.getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        this.tip.setLayout((Layout)layout);
                        this.label = new Label((Composite)this.tip, 0);
                        this.label.setForeground(display.getSystemColor(28));
                        this.label.setBackground(display.getSystemColor(29));
                        this.label.setData("_TABLEITEM", (Object)item);
                        if (item.getData() instanceof Target) {
                            this.label.setText(((ITarget)item.getData()).getTooltip());
                        } else {
                            this.label.setText(item.getText());
                        }
                        this.label.addListener(7, labelListener);
                        this.label.addListener(3, labelListener);
                        Point size = this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = table.toDisplay(rect.x, rect.y);
                        this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                        this.tip.setVisible(true);
                    }
                }
            }
        };
        table.addListener(12, tableListener);
        table.addListener(1, tableListener);
        table.addListener(5, tableListener);
        table.addListener(32, tableListener);
        this.makeActions();
        this.hookContextMenu();
        this.fillLocalToolbar(this.getViewSite().getActionBars().getToolBarManager());
        this.tableView.getTable().setSortColumn(column1);
        this.tableView.getTable().setSortDirection(1024);
        this.tableView.setComparator((ViewerComparator)new TableViewerComparator(1024, 1));
    }

    private void addDragAndDropSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TargetView.this.tableView.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
            }
        };
        this.tableView.addDragSupport(17, transfers, (DragSourceListener)listener);
        Transfer[] drops = new Transfer[]{FileTransfer.getInstance(), LocalSelectionTransfer.getTransfer()};
        this.tableView.addDropSupport(17, drops, (DropTargetListener)new DropListener());
    }

    public void setFocus() {
    }

    private void fillLocalToolbar(IToolBarManager manager) {
        manager.add((IAction)this.addTargetAction);
    }

    private void makeActions() {
        this.ta_remove = new RemoveTargetAction(Messages.TargetAction_Remove_Label);
        IHandlerService handlerService = (IHandlerService)this.getViewSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.edit.delete", (IHandler)new ActionHandler((IAction)this.ta_remove));
        this.ta_default = new TargetAction(Messages.TargetAction_Default_Label, false, false){

            @Override
            public void run() {
                ITarget[] targets;
                ITarget[] iTargetArray = targets = TargetManager.getDefault().getTargets();
                int n = targets.length;
                int n2 = 0;
                while (n2 < n) {
                    ITarget target = iTargetArray[n2];
                    target.setDefault(false);
                    target.setDirty(true);
                    TargetManager.getDefault().updateTarget(target);
                    ++n2;
                }
                this.getTarget().setDefault(true);
                this.getTarget().setDirty(true);
                TargetManager.getDefault().updateTarget(this.getTarget());
            }
        };
        this.addTargetAction = new Action(Messages.TargetAction_Add_Label){

            public void run() {
                Target nt = new Target();
                TargetManager.getDefault().addTarget(nt);
            }
        };
        this.addTargetAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.atmel.avr32.target", (String)"icons/lcl16/newtarget.gif"));
        this.addTargetAction.setToolTipText(Messages.TargetView_NewTargetTooltip);
        this.ta_List = new ListTargetsAction(Messages.TargetAction_List_Label);
        this.ta_List.setDescription(Messages.TargetAction_List_Desc);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TargetView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tableView.getControl());
        this.tableView.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableView);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.setRemoveAllWhenShown(true);
        ISelection s = this.tableView.getSelection();
        if (s instanceof StructuredSelection) {
            Object td = ((StructuredSelection)s).getFirstElement();
            if (td instanceof Target) {
                ITargetAction previous = null;
                for (ITargetAction action : TargetPlugin.getDefault().getTargetActions((ITarget)td)) {
                    if (previous != null && previous.getAppliesTo() != action.getAppliesTo()) {
                        manager.add((IContributionItem)new Separator());
                    }
                    ICommandService service = (ICommandService)this.getSite().getService(ICommandService.class);
                    service.getCommand(action.getActionDefinitionId()).define(action.getText(), null, service.getCategory(VIEW_ID));
                    if (action.isDynamic()) {
                        IContributionItem content = action.getContents();
                        if (content != null) {
                            manager.add(content);
                        }
                    } else {
                        manager.add((IAction)action);
                    }
                    previous = action;
                }
                this.ta_default.setTarget((ITarget)td);
                manager.add((IContributionItem)new Separator(MB_INTERNALS));
                manager.add((IAction)this.ta_default);
            }
            this.ta_remove.setTarget((ITarget)td);
            manager.add((IAction)this.ta_remove);
            manager.add((IContributionItem)new Separator("additions"));
        }
        manager.add((IAction)this.ta_List);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return VIEW_ID;
    }

    public void dispose() {
        super.dispose();
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.deactivateContext(this.contextActivation);
    }

    private class ColumnSelectionAdapter
    extends SelectionAdapter {
        private int column;

        public ColumnSelectionAdapter(int column) {
            this.column = column;
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn currentColumn;
            int direction = TargetView.this.tableView.getTable().getSortDirection();
            TableColumn sortColumn = TargetView.this.tableView.getTable().getSortColumn();
            if (sortColumn == (currentColumn = (TableColumn)e.widget)) {
                int n = direction == 128 ? 1024 : (direction = direction == 1024 ? 0 : 128);
                if (direction == 0) {
                    TargetView.this.tableView.getTable().setSortColumn(null);
                }
            } else {
                TargetView.this.tableView.getTable().setSortColumn(currentColumn);
                direction = 128;
            }
            TargetView.this.tableView.getTable().setSortDirection(direction);
            TargetView.this.tableView.setComparator((ViewerComparator)new TableViewerComparator(direction, this.column));
        }
    }

    private class DropListener
    extends DropTargetAdapter {
        private int currentOperation = 0;
        private int lastValidOperation = 0;

        private DropListener() {
        }

        public void dragOperationChanged(DropTargetEvent event) {
            this.doDropValidation(event);
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 1;
            this.doDropValidation(event);
        }

        public void drop(DropTargetEvent event) {
            if (!this.performDrop(event.data, event.item)) {
                event.detail = 0;
            }
            this.currentOperation = event.detail;
        }

        public void dropAccept(DropTargetEvent event) {
            if (!this.validateDrop(event.detail, event.currentDataType)) {
                event.detail = 0;
            }
        }

        public void dragEnter(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = 1;
            }
            this.doDropValidation(event);
        }

        protected boolean performDrop(Object data, Widget item) {
            final Object selection = ((IStructuredSelection)data).getFirstElement();
            if (selection instanceof IFile) {
                TargetJob fusejob = new TargetJob("Writing fuses", (ITarget)item.getData()){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ITargetInterface adapter = TargetPlugin.getDefault().getTargetInterface(this.getTarget(), false);
                            adapter.setTarget(this.getTarget());
                            FuseRegisterSettings fs = new FuseRegisterSettings(((IFile)selection).getFullPath());
                            IStatus status = adapter.applyFuseSettings(fs, monitor);
                            return status;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        return null;
                    }
                };
                fusejob.schedule();
            }
            return true;
        }

        private void doDropValidation(DropTargetEvent event) {
            if (event == null || event.item == null || event.item.getData() == null) {
                this.currentOperation = 0;
                event.detail = 0;
                return;
            }
            this.currentOperation = this.lastValidOperation;
            IStatus ok = TargetManager.getDefault().validateOperation((ITarget)event.item.getData(), 1);
            if (!ok.isOK()) {
                this.currentOperation = 0;
                event.detail = 0;
                return;
            }
            this.currentOperation = this.lastValidOperation;
            if (event.detail != 0) {
                this.lastValidOperation = event.detail;
            }
            this.currentOperation = this.validateDrop(event.detail, event.currentDataType) ? this.lastValidOperation : 0;
            event.detail = this.currentOperation;
        }

        protected boolean validateDrop(int operation, TransferData transferType) {
            return LocalSelectionTransfer.getTransfer().isSupportedType(transferType);
        }
    }

    private class RemoveTargetAction
    extends TargetAction {
        public RemoveTargetAction(String string) {
            super(string);
            this.setActionDefinitionId("org.eclipse.ui.edit.delete");
        }

        @Override
        public void run() {
            if (!TargetView.this.tableView.getSelection().isEmpty()) {
                Object[] o;
                Object[] objectArray = o = ((IStructuredSelection)TargetView.this.tableView.getSelection()).toArray();
                int n = o.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof Target) {
                        TargetManager.getDefault().removeTarget((ITarget)object);
                        TargetView.this.provider.update(null);
                    }
                    ++n2;
                }
            }
        }
    }

    public class TableViewerComparator
    extends ViewerComparator {
        int direction = 1024;
        int column = 1;

        public TableViewerComparator(int direction, int column) {
            this.direction = direction;
            this.column = column;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ITarget t1 = (ITarget)e1;
            ITarget t2 = (ITarget)e2;
            switch (this.column) {
                case 1: {
                    return t1.getName().compareTo(t2.getName());
                }
                case 2: {
                    return t1.getAdapterName().compareTo(t2.getAdapterName());
                }
                case 3: {
                    return t1.getBoardName().compareTo(t2.getBoardName());
                }
                case 4: {
                    return t1.getCpu().compareTo(t2.getCpu());
                }
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class ViewContentProvider
    implements IStructuredContentProvider,
    ITargetModifiedListener {
        private ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
            TargetManager.getDefault().removeTargetModifiedListener(this);
        }

        public Object[] getElements(Object parent) {
            return TargetManager.getDefault().getTargets();
        }

        void update(final ITarget target) {
            Runnable update = new Runnable(){

                @Override
                public void run() {
                    if (TargetView.this.tableView != null) {
                        if (target == null) {
                            TargetView.this.tableView.refresh();
                        } else {
                            TargetView.this.tableView.refresh((Object)target);
                        }
                    }
                }
            };
            Display.getDefault().syncExec(update);
        }

        @Override
        public void targetModified(ITarget target) {
            this.update(target);
        }
    }
}

