/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal;

import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetModifiedListener;
import com.atmel.avr32.target.internal.TargetManager;
import com.atmel.avr32.target.internal.TargetPropertySource;
import com.atmel.avr32.target.ui.internal.AbstractTargetPropertyPage;
import com.atmel.avr32.target.ui.internal.Messages;
import java.util.Date;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TargetPage
extends AbstractTargetPropertyPage
implements ITargetModifiedListener {
    private Text targetName;
    private Text targetBinaryName;
    private Text targetBinaryDate;
    private Section binariesSection;
    private Text targetNotes;
    private final ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            TargetPropertySource properties = TargetPage.this.getTargetProperties();
            if (arg0.getSource().equals(TargetPage.this.targetName)) {
                properties.setPropertyValue("target.name", TargetPage.this.targetName.getText());
            }
            if (arg0.getSource().equals(TargetPage.this.targetNotes)) {
                properties.setPropertyValue("target.description", TargetPage.this.targetNotes.getText());
            }
        }
    };
    TabbedPropertySheetPage page;

    public TargetPage() {
        TargetManager.getDefault().addTargetModifiedListener(this);
    }

    @Override
    public void targetModified(ITarget target) {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                TargetPropertySource properties = TargetPage.this.getTargetProperties();
                TargetPage.this.targetBinaryName.setText((String)properties.getPropertyValue("target.binary.name"));
                TargetPage.this.targetBinaryDate.setText(((Date)properties.getPropertyValue("target.binary.date")).toString());
                TargetPage.this.page.labelProviderChanged(null);
            }
        };
        PlatformUI.getWorkbench().getDisplay().asyncExec(update);
    }

    public void dispose() {
        TargetManager.getDefault().removeTargetModifiedListener(this);
        super.dispose();
    }

    private void createTargetNameControl(Composite composite) {
        this.targetName = this.getWidgetFactory().createText(composite, "");
        Label targetNameLabel = this.getWidgetFactory().createLabel(composite, Messages.TargetSection_TargetName);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 6);
        data.right = new FormAttachment(0, 85);
        targetNameLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)targetNameLabel, 5);
        data.right = new FormAttachment(100, -6);
        data.top = new FormAttachment(0, 6);
        this.targetName.setLayoutData((Object)data);
        this.targetName.addModifyListener(this.listener);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.page = aTabbedPropertySheetPage;
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.createTargetNameControl(composite);
        this.createBinarySection(composite);
    }

    private void createBinarySection(Composite parent) {
        this.binariesSection = this.getWidgetFactory().createSection(parent, 322);
        this.binariesSection.setText(Messages.TargetSection_Binaries_Title);
        this.binariesSection.setDescriptionControl((Control)this.addFormText((Composite)this.binariesSection, Messages.TargetSection_Binaries_Description));
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, -6);
        data.top = new FormAttachment((Control)this.targetName, 4);
        this.binariesSection.setLayoutData((Object)data);
        Composite composite = this.getWidgetFactory().createFlatFormComposite((Composite)this.binariesSection);
        this.binariesSection.setClient((Control)composite);
        Label label = this.getWidgetFactory().createLabel(composite, Messages.TargetSection_Binaries_Path);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(0, 85);
        data.top = new FormAttachment(0, 6);
        label.setLayoutData((Object)data);
        this.targetBinaryName = this.getWidgetFactory().createText(composite, "");
        this.targetBinaryName.setEditable(false);
        data = new FormData();
        data.left = new FormAttachment((Control)label, 4);
        data.right = new FormAttachment(100, -6);
        data.top = new FormAttachment(0, 6);
        this.targetBinaryName.setLayoutData((Object)data);
        label = this.getWidgetFactory().createLabel(composite, Messages.TargetSection_Binaries_Date);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(0, 85);
        data.top = new FormAttachment((Control)this.targetBinaryName, 4);
        label.setLayoutData((Object)data);
        this.targetBinaryDate = this.getWidgetFactory().createText(composite, "");
        this.targetBinaryDate.setEditable(false);
        data = new FormData();
        data.left = new FormAttachment((Control)label, 4);
        data.right = new FormAttachment(100, -6);
        data.top = new FormAttachment((Control)this.targetBinaryName, 6);
        this.targetBinaryDate.setLayoutData((Object)data);
    }

    public void refresh() {
        super.refresh();
        this.targetName.removeModifyListener(this.listener);
        TargetPropertySource properties = this.getTargetProperties();
        this.targetName.setText((String)properties.getPropertyValue("target.name"));
        this.targetBinaryName.setText((String)properties.getPropertyValue("target.binary.name"));
        this.targetBinaryDate.setText(((Date)properties.getPropertyValue("target.binary.date")).toString());
        this.targetName.addModifyListener(this.listener);
    }
}

