/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal;

import com.atmel.avr32.target.tool.model.IMemoryBlock;
import com.atmel.avr32.target.ui.internal.AbstractTargetPropertyPage;
import com.atmel.avr32.target.ui.internal.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class InformationPage
extends AbstractTargetPropertyPage
implements IHyperlinkListener {
    private Composite page;
    private Section memorySection;
    FormText memorySectionText;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        try {
            this.page = this.getWidgetFactory().createFlatFormComposite(parent);
            this.createMemorySection(this.page);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createMemorySection(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.memorySection = this.getWidgetFactory().createSection(composite, 322);
        this.memorySection.setLayoutData((Object)data);
        this.memorySection.setText(Messages.BoardSection_MemoryLabel);
        this.addHelpLink(this.memorySection, Messages.BoardSection_MemoryHelpLink);
        this.memorySectionText = this.addFormText((Composite)this.memorySection, Messages.BoardPage_Form_No_Data);
        this.memorySection.setClient((Control)this.memorySectionText);
    }

    @Override
    public void linkActivated(HyperlinkEvent e) {
        if (e.getSource().equals(this.memorySectionText)) {
            this.handleLinkActivated(e.getHref().toString());
        }
    }

    @Override
    public void linkEntered(HyperlinkEvent e) {
    }

    @Override
    public void linkExited(HyperlinkEvent e) {
    }

    public void refresh() {
        super.refresh();
        this.updateMemorySection();
    }

    private void updateMemorySection() {
        StringBuffer sb = new StringBuffer();
        sb.append("<form>");
        try {
            ArrayList<IMemoryBlock> mem;
            if (this.getTargetDescription().hasBoard()) {
                mem = this.getTargetDescription().getFlash(1);
                for (IMemoryBlock memory : mem) {
                    sb.append("<li indent=\"8\">");
                    sb.append(memory.toFormattedString());
                    sb.append("</li>");
                }
            }
            if (this.getTargetDescription().hasMCU()) {
                mem = this.getTargetDescription().getFlash(2);
                for (IMemoryBlock memory : mem) {
                    sb.append("<li indent=\"8\">");
                    sb.append(memory.toFormattedString());
                    sb.append("</li>");
                }
                if (mem.size() == 0) {
                    sb.append(MessageFormat.format(Messages.BoardPage_No_MCU_Memory, this.getTargetDescription().getCpu()));
                }
            }
            if (!this.getTargetDescription().hasBoard() && !this.getTargetDescription().hasMCU()) {
                sb.append(Messages.BoardPage_No_Data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sb.append("</form>");
        this.memorySectionText.setText(sb.toString(), true, false);
        this.page.layout();
    }
}

