/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal;

import com.atmel.avr32.target.FuseRegisterSettings;
import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.Target;
import com.atmel.avr32.target.TargetJob;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.internal.TargetManager;
import com.atmel.avr32.target.part.model.Fuse;
import com.atmel.avr32.target.part.model.FuseValue;
import com.atmel.avr32.target.part.model.Part;
import com.atmel.avr32.util.UtilPlugin;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.InvalidPropertiesFormatException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.part.FileEditorInput;

public class FuseEditor
extends SharedHeaderFormEditor {
    private static final String HELP_ID = "com.atmel.avr32.doc.guide.fuseeditor";
    private static final String VALUE = "value";
    private static final String HEX_PREFIX = "0x";
    private static final String SECTION = "section";
    public static final String ID = "com.atmel.avr32.target.FuseEditor";
    private static final int ITEM_COUNT_COMBO_LIMIT = 5;
    private static final String SUMMARY = "summary";
    private boolean dirty;
    private long fModificationStamp;
    private InputFileListener inputFileListener;
    private boolean invalid;
    private ListenerList listeners;
    private FuseRegisterSettings settings;

    private void clearChangeIndications(Control control) {
        String text;
        Object label = control.getData(SECTION);
        if (label != null && label instanceof Section && (text = ((Section)label).getText()).endsWith("*")) {
            ((Section)label).setText(text.substring(0, text.length() - 1));
            ((Section)label).layout();
        }
        control.setToolTipText(null);
    }

    public void close() {
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                FuseEditor.this.getSite().getPage().closeEditor((IEditorPart)FuseEditor.this, false);
            }
        });
    }

    private void createFormComposite(final ScrolledForm form, FormToolkit toolkit) {
        int fusecount = 0;
        for (Fuse fuse : this.getPart().getFuses()) {
            Label label;
            ++fusecount;
            final String key = fuse.getName();
            final ArrayList<FuseValue> values = fuse.getValues();
            final int length = fuse.getLength();
            Section section = toolkit.createSection(form.getBody(), 448);
            TableWrapData gd = new TableWrapData(256);
            gd.colspan = 1;
            section.setLayoutData((Object)gd);
            section.setLayout((Layout)new TableWrapLayout());
            section.setText(String.valueOf(fuse.getName()) + " - " + fuse.getTitle());
            if (fuse.getDescription() != null) {
                section.setDescription(fuse.getDescription());
            }
            Composite client = toolkit.createComposite((Composite)section);
            TableWrapLayout layout = new TableWrapLayout();
            layout.numColumns = 2;
            client.setLayout((Layout)layout);
            section.setClient((Control)client);
            if (fuse.getValues().size() > 5) {
                label = toolkit.createLabel(client, String.valueOf(fuse.getLabel()) + ":");
                label.setLayoutData((Object)new TableWrapData(2, 32, 1, 1));
                final Combo combo = new Combo(client, 76);
                combo.setData((Object)fuse.getName());
                this.listeners.add((Object)combo);
                combo.setData(SECTION, (Object)section);
                combo.setLayoutData((Object)new TableWrapData(256, 32, 1, 1));
                int count = 0;
                int selection = 0;
                for (FuseValue fvalue : fuse.getValues()) {
                    combo.add(fvalue.getDescription());
                    if (this.settings.containsFuse(key) && Long.decode(this.settings.getFuseValue(key)).longValue() == fvalue.getNumeric()) {
                        selection = count;
                    }
                    ++count;
                }
                combo.select(selection);
                combo.addListener(13, new Listener(){

                    public void handleEvent(Event arg0) {
                        FuseEditor.this.settings.setFuseValue(key, FuseEditor.HEX_PREFIX + Long.toHexString(((FuseValue)values.get(combo.getSelectionIndex())).getNumeric()));
                        FuseEditor.this.notifyDirty();
                    }
                });
            } else if (fuse.getValues().size() > 0) {
                for (FuseValue fvalue : fuse.getValues()) {
                    final long value = fvalue.getNumeric();
                    Button btn = toolkit.createButton(client, fvalue.getDescription(), 16);
                    btn.setData((Object)fuse.getName());
                    btn.setData(VALUE, (Object)(HEX_PREFIX + Long.toHexString(value)));
                    btn.setData(SECTION, (Object)section);
                    this.listeners.add((Object)btn);
                    btn.setLayoutData((Object)new TableWrapData(256, 32, 1, 2));
                    if (this.settings.containsFuse(key) && Long.decode(this.settings.getFuseValue(key)) == value) {
                        btn.setSelection(true);
                    }
                    btn.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            FuseEditor.this.settings.setFuseValue(key, FuseEditor.HEX_PREFIX + Long.toHexString(value));
                            FuseEditor.this.notifyDirty();
                        }
                    });
                }
            } else if (fuse.getType() == Fuse.FuseValueType.TOGGLE) {
                final Button btn = toolkit.createButton(client, fuse.getLabel(), 32);
                btn.setData(SECTION, (Object)section);
                btn.setData((Object)fuse.getName());
                this.listeners.add((Object)btn);
                btn.setLayoutData((Object)new TableWrapData(256, 32, 1, 2));
                if (this.settings.containsFuse(key) && Long.decode(this.settings.getFuseValue(key)) == 1L) {
                    btn.setSelection(true);
                }
                btn.addListener(13, new Listener(){

                    public void handleEvent(Event arg0) {
                        if (btn.getSelection()) {
                            FuseEditor.this.settings.setFuseValue(key, "0x1");
                        } else {
                            FuseEditor.this.settings.setFuseValue(key, "0x0");
                        }
                        FuseEditor.this.notifyDirty();
                    }
                });
            } else {
                label = toolkit.createLabel(client, String.valueOf(fuse.getLabel()) + ":");
                label.setLayoutData((Object)new TableWrapData(2, 32, 1, 1));
                final Text text = toolkit.createText(client, HEX_PREFIX + Long.toHexString(fuse.getValue()), 2048);
                text.setData((Object)fuse.getName());
                text.setData(SECTION, (Object)section);
                this.listeners.add((Object)text);
                text.setLayoutData((Object)new TableWrapData(256, 32, 1, 1));
                if (this.settings.containsFuse(key)) {
                    text.setText(this.settings.getFuseValue(key));
                }
                text.addListener(24, new Listener(){

                    public void handleEvent(Event arg0) {
                        try {
                            long value = Long.decode(text.getText());
                            if (value >> length > 0L) {
                                form.setMessage("The value is too large for " + length + " bits.", 3);
                                FuseEditor.this.invalid = true;
                                return;
                            }
                            if (value < 0L) {
                                form.setMessage("The value cannot be negative.", 3);
                                FuseEditor.this.invalid = true;
                                return;
                            }
                        }
                        catch (Exception exception) {
                            form.setMessage("Please enter a octal, decimal or hexadecimal value.", 3);
                            FuseEditor.this.invalid = true;
                            return;
                        }
                        FuseEditor.this.invalid = false;
                        FuseEditor.this.settings.setFuseValue(key, text.getText());
                        form.setMessage(null, 0);
                        FuseEditor.this.notifyDirty();
                    }
                });
            }
            section.setClient((Control)client);
        }
        if (fusecount % 2 != 0) {
            Composite c = toolkit.createComposite(form.getBody());
            c.setLayoutData((Object)new TableWrapData());
        }
    }

    private void createSummarySection(ScrolledForm form, FormToolkit toolkit) {
        Section section = toolkit.createSection(form.getBody(), 322);
        section.setText("Notes");
        TableWrapData gd = new TableWrapData(256);
        gd.colspan = 2;
        section.setLayoutData((Object)gd);
        section.setLayout((Layout)new TableWrapLayout());
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)new GridLayout());
        section.setClient((Control)client);
        final Text text = toolkit.createText(client, null, 2114);
        GridData ld = new GridData(4, 4, true, true);
        ld.heightHint = 100;
        text.setLayoutData((Object)ld);
        if (this.settings.containsFuse(SUMMARY)) {
            text.setText(this.settings.getFuseValue(SUMMARY));
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                FuseEditor.this.settings.setFuseValue(FuseEditor.SUMMARY, text.getText());
                FuseEditor.this.notifyDirty();
            }
        });
    }

    private void doLoad(IResource file) {
        this.fModificationStamp = file.getModificationStamp();
        this.setPartName(file.getName());
        try {
            this.settings = new FuseRegisterSettings();
            this.settings.load(file.getFullPath());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvalidPropertiesFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        IResource file = (IResource)this.getEditorInput().getAdapter(IResource.class);
        this.doSave(file);
    }

    private void doSave(IResource file) {
        this.settings.setFuseValue("MCU", this.getPart().getName());
        try {
            this.settings.save(file.getFullPath());
            this.fModificationStamp = file.getModificationStamp();
            this.dirty = false;
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object control = objectArray[n2];
                this.clearChangeIndications((Control)control);
                ++n2;
            }
            this.getActivePageInstance().getManagedForm().getForm().setMessage(null, 0);
            this.firePropertyChange(257);
        }
        catch (FileNotFoundException e) {
            UtilPlugin.error((Object)e);
        }
        catch (IOException e) {
            UtilPlugin.error((Object)e);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
        SaveAsDialog rd = new SaveAsDialog(this.getSite().getShell());
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        rd.setOriginalFile(file);
        if (rd.open() == 0) {
            file = ResourcesPlugin.getWorkspace().getRoot().getFile(rd.getResult());
            this.doSave((IResource)file);
            this.setInputWithNotify((IEditorInput)new FileEditorInput(file));
        }
    }

    protected void createPages() {
        super.createPages();
        if (this.getPageCount() == 1 && this.getContainer() instanceof CTabFolder) {
            ((CTabFolder)this.getContainer()).setTabHeight(0);
        }
    }

    protected void setInputWithNotify(IEditorInput input) {
        this.doLoad((IResource)((FileEditorInput)input).getFile());
        super.setInputWithNotify(input);
    }

    protected void setInput(IEditorInput input) {
        this.doLoad((IResource)((FileEditorInput)input).getFile());
        super.setInput(input);
    }

    public void fileChanged() {
        if (!MessageDialog.openConfirm((Shell)this.getSite().getShell(), (String)"File Changed", (String)"The file has been changed on the file system. Do you want to load the changes?")) {
            return;
        }
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                FuseEditor.this.getSite().getPage().closeEditor((IEditorPart)FuseEditor.this, false);
                try {
                    FuseEditor.this.getSite().getPage().openEditor(FuseEditor.this.getEditorInput(), FuseEditor.ID);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private Part getPart() {
        return PartRegistry.getPart(this.settings.getPartId());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.inputFileListener = new InputFileListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.inputFileListener);
        new ActivationListener(site.getWorkbenchWindow().getPartService());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return !this.invalid;
    }

    protected void sanityCheckState() {
        IResource file = (IResource)this.getEditorInput().getAdapter(IResource.class);
        if (file == null) {
            return;
        }
        long stamp = file.getModificationStamp();
        if (stamp != this.fModificationStamp) {
            this.fModificationStamp = stamp;
            this.fileChanged();
        }
    }

    private void setFieldValue(Control control, String key, String value, boolean notify) {
        String cValue;
        boolean changes = false;
        String tooltip = null;
        if (control instanceof Text && !(cValue = ((Text)control).getText()).equals(value)) {
            tooltip = MessageFormat.format("Old value \"{0}\", new value \"{1}\"", cValue, value);
            ((Text)control).setText(value);
            changes = true;
        }
        if (control instanceof Combo) {
            int count = 0;
            ArrayList<Fuse> fuses = this.getPart().getFuses();
            block0: for (Fuse fuse : fuses) {
                if (!fuse.getName().equals(key)) continue;
                for (FuseValue fuseValue : fuse.getValues()) {
                    if (fuseValue.getNumeric() == Long.decode(value).longValue() && ((Combo)control).getSelectionIndex() != count) {
                        tooltip = MessageFormat.format("Old value \"{0}\", new value \"{1}\"", ((Combo)control).getText(), ((Combo)control).getItem(count));
                        ((Combo)control).select(count);
                        changes = true;
                        continue block0;
                    }
                    ++count;
                }
            }
        }
        if (control instanceof Button) {
            if ((((Button)control).getStyle() & 0x20) != 0) {
                boolean nValue;
                boolean cValue2 = ((Button)control).getSelection();
                boolean bl = nValue = Long.decode(this.settings.getFuseValue(key)) == 1L;
                if (nValue != cValue2) {
                    tooltip = MessageFormat.format("Old value \"{0}\", new value \"{1}\"", cValue2, nValue);
                    ((Button)control).setSelection(nValue);
                    changes = true;
                }
            } else if ((((Button)control).getStyle() & 0x10) != 0) {
                String data = (String)((Button)control).getData(VALUE);
                boolean cValue3 = ((Button)control).getSelection();
                boolean nValue = data.equals(value);
                if (nValue != cValue3) {
                    tooltip = MessageFormat.format("Old value \"{0}\", new value \"{1}\"", cValue3, nValue);
                    ((Button)control).setSelection(nValue);
                    changes = true;
                }
            }
        }
        if (changes && notify) {
            String text;
            this.notifyDirty();
            Object label = control.getData(SECTION);
            if (label != null && label instanceof Section && !(text = ((Section)label).getText()).endsWith("*")) {
                ((Section)label).setText(String.valueOf(text) + "*");
                ((Section)label).layout();
            }
            control.setToolTipText(tooltip);
        }
    }

    private void notifyDirty() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    private void updateForm(final IManagedForm form, final ITarget target, final IStatus status) {
        Runnable update = new Runnable(){

            @Override
            public void run() {
                form.getForm().setRedraw(false);
                form.getForm().setMessage(null, 0);
                if (status.getSeverity() == 0) {
                    Object[] objectArray = FuseEditor.this.listeners.getListeners();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object control = objectArray[n2];
                        String key = (String)((Control)control).getData();
                        String value = FuseEditor.this.settings.getFuseValue(key);
                        FuseEditor.this.clearChangeIndications((Control)control);
                        FuseEditor.this.setFieldValue((Control)control, key, value, true);
                        form.getForm().setMessage("The form has been updated with values from target device " + target.getName(), 1);
                        ++n2;
                    }
                    form.getForm().setMessage("Could not read fuse values from target device " + target.getName(), 2);
                }
                form.getForm().setRedraw(true);
            }
        };
        Display.getDefault().asyncExec(update);
    }

    protected void addPages() {
        this.listeners = new ListenerList();
        FormPage page = new FormPage((FormEditor)this, "1", "1"){

            public void createFormContent(IManagedForm managedForm) {
                ScrolledForm form = managedForm.getForm();
                form.setAlwaysShowScrollBars(true);
                FormToolkit toolkit = managedForm.getToolkit();
                toolkit.decorateFormHeading(form.getForm());
                form.setText(String.valueOf(FuseEditor.this.getPart().getName()) + " fuse settings");
                TableWrapLayout layout = new TableWrapLayout();
                layout.leftMargin = 10;
                layout.rightMargin = 10;
                layout.numColumns = 2;
                layout.makeColumnsEqualWidth = true;
                form.getBody().setLayout((Layout)layout);
                FuseEditor.this.createFormComposite(form, toolkit);
                FuseEditor.this.createSummarySection(form, toolkit);
                Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
                DropTarget dt = new DropTarget((Control)form, 17);
                dt.setTransfer(transfers);
                dt.addDropListener((DropTargetListener)new DropListener());
                this.getSite().getWorkbenchWindow().getWorkbench().getHelpSystem().setHelp((Control)form, FuseEditor.HELP_ID);
            }
        };
        try {
            this.addPage((IFormPage)page);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    private class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart fActivePart;
        private IPartService fPartService;

        public ActivationListener(IPartService partService) {
            this.fPartService = partService;
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.fPartService = null;
        }

        private void handleActivation() {
            if (this.fActivePart == FuseEditor.this) {
                FuseEditor.this.sanityCheckState();
            }
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == FuseEditor.this.getEditorSite().getWorkbenchWindow()) {
                window.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ActivationListener.this.handleActivation();
                    }
                });
            }
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    private class DropListener
    extends DropTargetAdapter {
        private int currentOperation = 0;
        private int lastValidOperation = 0;

        private DropListener() {
        }

        private void doDropValidation(DropTargetEvent event) {
            if (event.detail != 0) {
                this.lastValidOperation = event.detail;
            }
            this.currentOperation = this.validateDrop(event.detail, event.currentDataType) ? this.lastValidOperation : 0;
            event.detail = this.currentOperation;
        }

        public void dragEnter(DropTargetEvent event) {
            if (event.detail == 16) {
                event.detail = 1;
            }
            this.doDropValidation(event);
        }

        public void dragOperationChanged(DropTargetEvent event) {
            this.doDropValidation(event);
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 1;
            this.doDropValidation(event);
        }

        public void drop(DropTargetEvent event) {
            if (!this.performDrop(event.data)) {
                event.detail = 0;
            }
            this.currentOperation = event.detail;
        }

        public void dropAccept(DropTargetEvent event) {
            if (!this.validateDrop(event.detail, event.currentDataType)) {
                event.detail = 0;
            }
        }

        protected boolean performDrop(Object data) {
            Object selection = ((IStructuredSelection)data).getFirstElement();
            if (selection instanceof Target) {
                IStatus ok = TargetManager.getDefault().validateOperation((ITarget)selection, 1);
                if (!ok.isOK()) {
                    TargetPlugin.operationStatusMessage(ok);
                    return false;
                }
                TargetJob fusejob = new TargetJob("Reading fuses", (ITarget)selection){

                    protected IStatus run(IProgressMonitor monitor) {
                        ITargetInterface adapter = TargetPlugin.getDefault().getTargetInterface(this.getTarget(), false);
                        adapter.setTarget(this.getTarget());
                        IStatus status = adapter.readFuseSettings(FuseEditor.this.settings, monitor);
                        if (!status.isOK()) {
                            return status;
                        }
                        FuseEditor.this.updateForm(FuseEditor.this.getActivePageInstance().getManagedForm(), this.getTarget(), status);
                        return status;
                    }
                };
                fusejob.schedule();
            }
            return true;
        }

        protected boolean validateDrop(int operation, TransferData transferType) {
            return LocalSelectionTransfer.getTransfer().isSupportedType(transferType);
        }
    }

    private class InputFileListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private InputFileListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                IResourceDelta delta = event.getDelta();
                try {
                    delta.accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IFile file;
            IResource resource = delta.getResource();
            if (resource instanceof IFile && (file = (IFile)resource).equals((Object)((IFileEditorInput)FuseEditor.this.getEditorInput()).getFile())) {
                if (delta.getKind() == 2 || delta.getKind() == 262144) {
                    FuseEditor.this.close();
                }
                return false;
            }
            return true;
        }
    }
}

