/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal;

import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.ToolRegistry;
import com.atmel.avr32.target.internal.TargetPropertySource;
import com.atmel.avr32.target.part.model.Part;
import com.atmel.avr32.target.tool.model.Tool;
import com.atmel.avr32.target.ui.internal.AbstractTargetPropertyPage;
import com.atmel.avr32.target.ui.internal.AbstractToolSection;
import com.atmel.avr32.target.ui.internal.ClockSection;
import com.atmel.avr32.target.ui.internal.ConnectionSection;
import com.atmel.avr32.target.ui.internal.Messages;
import com.atmel.avr32.target.ui.internal.VoltageSection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class DetailsPage
extends AbstractTargetPropertyPage
implements IHyperlinkListener {
    private static final String EMPTY_STRING = "";
    String[] titles = new String[]{"Type", "Description"};
    private CCombo targetAdapter;
    private VoltageSection voltageSection;
    private AbstractToolSection clockSection;
    private AbstractToolSection connectionSection;
    private Text targetMCU;
    private CCombo targetBoard;
    private Label targetBoardLabel;
    private CCombo targetClock;
    private final ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            TargetPropertySource properties = DetailsPage.this.getTargetProperties();
            if (arg0.getSource().equals(DetailsPage.this.targetAdapter)) {
                properties.setPropertyValue("target.adapter", DetailsPage.this.targetAdapter.getText());
                Tool tool = ToolRegistry.getTool(DetailsPage.this.targetAdapter.getText());
                DetailsPage.this.clockSection.setTool(tool);
                DetailsPage.this.voltageSection.setTool(tool);
                DetailsPage.this.connectionSection.setTool(tool);
                DetailsPage.this.targetMCU.setText(DetailsPage.EMPTY_STRING);
                DetailsPage.this.targetBoard.setText("Unspecified");
            }
        }
    };
    private final Listener listener2 = new Listener(){

        public void handleEvent(Event event) {
            Widget arg0 = event.widget;
            TargetPropertySource properties = DetailsPage.this.getTargetProperties();
            if (arg0.equals(DetailsPage.this.targetBoard)) {
                properties.setPropertyValue("target.board", DetailsPage.this.targetBoard.getText());
            }
            if (arg0.equals(DetailsPage.this.targetMCU)) {
                properties.setPropertyValue("target.cpu", DetailsPage.this.targetMCU.getText());
                Part part = PartRegistry.getPart(DetailsPage.this.targetMCU.getText());
                if (part != null) {
                    DetailsPage.this.populateBoards();
                    if (part.isClockable()) {
                        DetailsPage.this.targetClock.setEnabled(true);
                    } else {
                        DetailsPage.this.targetClock.setEnabled(false);
                    }
                }
            }
            if (arg0.equals(DetailsPage.this.targetClock)) {
                int count = 0;
                String[] stringArray = DetailsPage.this.targetClock.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (item.equals(DetailsPage.this.targetClock.getText())) break;
                    ++count;
                    ++n2;
                }
                properties.setPropertyValue("target.mcu.clock", new Integer(count));
            }
        }
    };
    private Button deviceBrowseButton;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        try {
            Composite page = this.getWidgetFactory().createFlatFormComposite(parent);
            Section section = this.getWidgetFactory().createSection(page, 320);
            section.setText("Details");
            FormData fd = new FormData();
            fd.left = new FormAttachment(0);
            fd.right = new FormAttachment(100);
            section.setLayoutData((Object)fd);
            Composite composite = this.getWidgetFactory().createComposite((Composite)section);
            GridLayout gl = GridLayoutFactory.fillDefaults().create();
            gl.marginRight = 4;
            gl.marginTop = 4;
            gl.marginBottom = 4;
            gl.numColumns = 5;
            composite.setLayout((Layout)gl);
            section.setClient((Control)composite);
            this.createDebuggerControl(composite);
            this.createDeviceControl(composite);
            this.createMCUClockControl(composite);
            this.createBoardControl(composite);
            this.connectionSection = new ConnectionSection(page, Messages.AdapterSection_ConnectionLabel, this.getWidgetFactory(), (Control)section);
            this.clockSection = new ClockSection(page, Messages.AdapterSection_ClockLabel, this.getWidgetFactory(), (Control)this.connectionSection.getControl(), 0);
            this.addHelpLink(this.clockSection.getControl(), Messages.AdapterPage_ClockHelpLink);
            this.voltageSection = new VoltageSection(page, Messages.BoardSection_VoltageLabel, this.getWidgetFactory(), (Control)this.clockSection.getControl(), 0);
            this.addHelpLink(this.voltageSection.getControl(), Messages.AdapterPage_VoltageHelpLink);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createDebuggerControl(Composite parent) {
        Tool[] adapters;
        this.getWidgetFactory().createLabel(parent, Messages.AdapterPage_AdapterLabel);
        this.targetAdapter = this.getWidgetFactory().createCCombo(parent, 8);
        this.targetAdapter.addModifyListener(this.listener);
        this.targetAdapter.setLayoutData((Object)new GridData(4, 1, true, false));
        Tool[] toolArray = adapters = ToolRegistry.getTools(1);
        int n = adapters.length;
        int n2 = 0;
        while (n2 < n) {
            Tool tool = toolArray[n2];
            this.targetAdapter.add(tool.getName());
            ++n2;
        }
    }

    public void refresh() {
        super.refresh();
        this.targetAdapter.removeModifyListener(this.listener);
        TargetPropertySource properties = this.getTargetProperties();
        this.targetAdapter.setText((String)properties.getPropertyValue("target.adapter"));
        this.connectionSection.setTarget(this.getTargetDescription());
        Tool tool = ToolRegistry.getTool(this.targetAdapter.getText());
        this.connectionSection.setTool(tool);
        this.voltageSection.setTarget(this.getTargetDescription());
        this.voltageSection.setTool(tool);
        this.clockSection.setTarget(this.getTargetDescription());
        this.clockSection.setTool(tool);
        this.targetAdapter.addModifyListener(this.listener);
        this.targetBoard.removeListener(24, this.listener2);
        this.targetMCU.removeListener(24, this.listener2);
        this.targetClock.removeListener(24, this.listener2);
        this.targetBoard.setText((String)properties.getPropertyValue("target.board"));
        this.targetMCU.setText((String)properties.getPropertyValue("target.cpu"));
        this.targetClock.select(((Integer)properties.getPropertyValue("target.mcu.clock")).intValue());
        if (this.getTargetDescription() == null || this.getTargetDescription().getPart() == null || !this.getTargetDescription().getPart().isClockable()) {
            this.targetClock.setEnabled(false);
        } else {
            this.targetClock.setEnabled(true);
        }
        this.targetBoard.addListener(24, this.listener2);
        this.targetMCU.addListener(24, this.listener2);
        this.targetClock.addListener(24, this.listener2);
    }

    private void populateBoards() {
        Tool[] boards;
        String currentBoard = this.targetBoard.getText();
        boolean mayReuse = false;
        this.targetBoard.removeAll();
        Tool[] toolArray = boards = ToolRegistry.getTools(2);
        int n = boards.length;
        int n2 = 0;
        while (n2 < n) {
            Tool board = toolArray[n2];
            String[] stringArray = board.getSupportedParts();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String partName = stringArray[n4];
                if (partName.equals(this.getTargetDescription().getCpu())) {
                    this.targetBoard.add(board.getName());
                }
                if (currentBoard.equals(board.getName())) {
                    mayReuse = true;
                }
                ++n4;
            }
            ++n2;
        }
        if (mayReuse) {
            this.targetBoard.setText(currentBoard);
        }
    }

    private void createBoardControl(Composite composite) {
        this.getWidgetFactory().createLabel(composite, Messages.BoardSection_BoardLabel);
        this.targetBoard = this.getWidgetFactory().createCCombo(composite, 8);
        this.targetBoard.addListener(24, this.listener2);
        GridData gd = new GridData(4, 1, true, false);
        gd.horizontalSpan = 2;
        this.targetBoard.setLayoutData((Object)gd);
    }

    @Override
    public void linkActivated(HyperlinkEvent e) {
        Tool adapter = ToolRegistry.getTool(this.getTargetDescription().getAdapterName());
        this.handleLinkActivated("http://www.atmel.com/dyn/products/product_card.asp?part_id=" + adapter.getPartID());
        if (e.getSource().equals(this.targetBoardLabel)) {
            this.handleLinkActivated("http://www.atmel.com/dyn/products/product_card.asp?part_id=" + adapter.getPartID());
        }
    }

    @Override
    public void linkEntered(HyperlinkEvent e) {
    }

    @Override
    public void linkExited(HyperlinkEvent e) {
    }

    private void createMCUClockControl(Composite composite) {
        this.getWidgetFactory().createLabel(composite, Messages.BoardPage_ClockSourceLabel);
        this.targetClock = this.getWidgetFactory().createCCombo(composite, 8);
        this.targetClock.addListener(24, this.listener2);
        this.targetClock.add(Messages.BoardPage_OscillatorLabel);
        this.targetClock.add(Messages.BoardPage_CrystalLabel);
        this.targetClock.add(Messages.BoardPage_ExternalLabel);
        this.targetClock.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    private void createDeviceControl(Composite parent) {
        this.getWidgetFactory().createLabel(parent, Messages.BoardPage_MCU);
        this.targetMCU = this.getWidgetFactory().createText(parent, EMPTY_STRING);
        this.targetMCU.setEditable(false);
        this.targetMCU.addListener(24, this.listener2);
        this.targetMCU.setLayoutData((Object)new GridData(4, 1, true, false));
        this.deviceBrowseButton = this.getWidgetFactory().createButton(parent, Messages.BoardPage_SelectMCULabel, 0);
        this.deviceBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Tool debugger = ToolRegistry.getTool(DetailsPage.this.getTargetDescription().getAdapterName());
                try {
                    String mcu = debugger.getPartSelectionProvider().getPart(DetailsPage.this.getTargetDescription());
                    if (mcu != null && !mcu.equals(DetailsPage.EMPTY_STRING)) {
                        DetailsPage.this.targetMCU.setText(mcu);
                    }
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }
}

