/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal;

import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.internal.TargetPropertySource;
import com.atmel.avr32.target.ui.internal.AbstractTargetPropertyPage;
import com.atmel.avr32.target.ui.internal.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DaisyChainPage
extends AbstractTargetPropertyPage {
    private Text devsBefore;
    private Text bitsBefore;
    private Text devsAfter;
    private Text bitsAfter;
    private static final String emptyString = "";
    private final Listener listener = new Listener(){

        public void handleEvent(Event event) {
            DaisyChainPage.this.updateTargetFromGui(event.widget);
        }
    };
    private Button enableButton;
    private Label devsBeforeLabel;
    private Label bitsBeforeLabel;
    private Label devsAfterLabel;
    private Label bitsAfterLabel;
    private CLabel statusText;
    private int maxDaisyChainValue = 256;
    ISharedImages images = PlatformUI.getWorkbench().getSharedImages();

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory wf = this.getWidgetFactory();
        Composite page = wf.createComposite(parent);
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.marginLeft = 5;
        rowLayout.marginTop = 5;
        page.setLayout((Layout)rowLayout);
        this.enableButton = wf.createButton(page, Messages.DaisyChainPage_Enable_Daisy_Chain, 32);
        this.enableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                DaisyChainPage.this.updateTargetFromGui(e.widget);
                DaisyChainPage.this.enableDaisyChainSettings(DaisyChainPage.this.enableButton.getSelection());
            }
        });
        Composite daisyChainPage = wf.createFlatFormComposite(page);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment(0, 4);
        this.devsBeforeLabel = wf.createLabel(daisyChainPage, Messages.DaisyChainPage_Devices_Before);
        this.devsBeforeLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.devsBeforeLabel, 5);
        data.top = new FormAttachment(0, 4);
        data.right = new FormAttachment(50, -5);
        data.width = 20;
        this.devsBefore = wf.createText(daisyChainPage, emptyString);
        this.devsBefore.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(50, 5);
        data.top = new FormAttachment(0, 4);
        this.bitsBeforeLabel = wf.createLabel(daisyChainPage, Messages.DaisyChainPage_Bits_Before);
        this.bitsBeforeLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bitsBeforeLabel, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment(0, 4);
        data.width = 20;
        this.bitsBefore = wf.createText(daisyChainPage, emptyString);
        this.bitsBefore.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.devsBeforeLabel, 0, 16384);
        data.top = new FormAttachment((Control)this.devsBeforeLabel, 4, 16384);
        this.devsAfterLabel = wf.createLabel(daisyChainPage, Messages.DaisyChainPage_Devices_After);
        this.devsAfterLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.devsBefore, 0, 16384);
        data.top = new FormAttachment((Control)this.devsBefore, 4, 16384);
        data.right = new FormAttachment((Control)this.devsBefore, 0, 131072);
        this.devsAfter = wf.createText(daisyChainPage, emptyString);
        this.devsAfter.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bitsBeforeLabel, 0, 16384);
        data.top = new FormAttachment((Control)this.bitsBeforeLabel, 4, 16384);
        this.bitsAfterLabel = wf.createLabel(daisyChainPage, Messages.DaisyChainPage_Bits_After);
        this.bitsAfterLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bitsBefore, 0, 16384);
        data.top = new FormAttachment((Control)this.bitsBefore, 4, 16384);
        data.right = new FormAttachment((Control)this.bitsBefore, 0, 131072);
        data.width = 20;
        this.bitsAfter = wf.createText(daisyChainPage, emptyString);
        this.bitsAfter.setLayoutData((Object)data);
        this.statusText = wf.createCLabel(page, emptyString);
        this.registerListener();
    }

    public void refresh() {
        super.refresh();
        this.unregisterListener();
        TargetPropertySource props = this.getTargetProperties();
        if (!TargetPlugin.getDefault().supportsCapability(this.getTargetDescription(), TargetPlugin.CapabilityId.daisychain.toString())) {
            this.enableDaisyChainSettings(false);
            this.enableButton.setSelection(false);
            this.enableButton.setEnabled(false);
            this.devsBefore.setText(emptyString);
            this.devsAfter.setText(emptyString);
            this.bitsBefore.setText(emptyString);
            this.bitsAfter.setText(emptyString);
            this.setStatus(Messages.DaisyChainPage_Daisy_Chain_Not_Supported, this.images.getImage("IMG_OBJS_INFO_TSK"));
            return;
        }
        this.enableButton.setEnabled(true);
        this.setStatus(emptyString);
        boolean daisyChainEnabled = Boolean.parseBoolean(String.valueOf(props.getPropertyValue("target.daisy.enabled")));
        this.enableDaisyChainSettings(daisyChainEnabled);
        this.enableButton.setSelection(daisyChainEnabled);
        this.devsBefore.setText(String.valueOf(props.getPropertyValue("target.daisy.devsbefore")));
        this.devsAfter.setText(String.valueOf(props.getPropertyValue("target.daisy.devsafter")));
        this.bitsBefore.setText(String.valueOf(props.getPropertyValue("target.daisy.bitsbefore")));
        this.bitsAfter.setText(String.valueOf(props.getPropertyValue("target.daisy.bitsafter")));
        this.registerListener();
    }

    private void setStatus(String statusMessage) {
        this.setStatus(statusMessage, null);
    }

    private void setStatus(String statusMessage, Image image) {
        this.statusText.setImage(image);
        this.statusText.setText(statusMessage);
        this.statusText.pack();
    }

    private void unregisterListener() {
        this.devsBefore.removeListener(24, this.listener);
        this.devsAfter.removeListener(24, this.listener);
        this.bitsBefore.removeListener(24, this.listener);
        this.bitsAfter.removeListener(24, this.listener);
    }

    private void registerListener() {
        this.devsBefore.addListener(24, this.listener);
        this.devsAfter.addListener(24, this.listener);
        this.bitsBefore.addListener(24, this.listener);
        this.bitsAfter.addListener(24, this.listener);
    }

    private void enableDaisyChainSettings(boolean enable) {
        this.devsBefore.setEnabled(enable);
        this.devsAfter.setEnabled(enable);
        this.bitsBefore.setEnabled(enable);
        this.bitsAfter.setEnabled(enable);
        this.devsBeforeLabel.setEnabled(enable);
        this.devsAfterLabel.setEnabled(enable);
        this.bitsBeforeLabel.setEnabled(enable);
        this.bitsAfterLabel.setEnabled(enable);
    }

    private void updateTargetFromGui(Object control) {
        TargetPropertySource props = this.getTargetProperties();
        Assert.isNotNull((Object)props);
        IStatus status = this.validateDaisyChainSettings();
        if (!status.isOK()) {
            this.setStatus(status.getMessage(), this.images.getImage("IMG_OBJS_WARN_TSK"));
            return;
        }
        this.setStatus(emptyString);
        if (this.enableButton.equals(control)) {
            props.setPropertyValue("target.daisy.enabled", new Boolean(this.enableButton.getSelection()));
        } else if (this.devsBefore.equals(control)) {
            props.setPropertyValue("target.daisy.devsbefore", Integer.decode(this.devsBefore.getText()));
        } else if (this.devsAfter.equals(control)) {
            props.setPropertyValue("target.daisy.devsafter", Integer.decode(this.devsAfter.getText()));
        } else if (this.bitsBefore.equals(control)) {
            props.setPropertyValue("target.daisy.bitsbefore", Integer.decode(this.bitsBefore.getText()));
        } else if (this.bitsAfter.equals(control)) {
            props.setPropertyValue("target.daisy.bitsafter", Integer.decode(this.bitsAfter.getText()));
        }
    }

    private IStatus validateDaisyChainSettings() {
        if (!this.validNumber(this.devsBefore.getText())) {
            return new Status(4, "com.atmel.avr32.target", Messages.DaisyChainPage_Devices_Before_Illegal);
        }
        if (!this.validNumber(this.devsAfter.getText())) {
            return new Status(4, "com.atmel.avr32.target", Messages.DaisyChainPage_Devices_After_Illegal);
        }
        if (!this.validNumber(this.bitsBefore.getText())) {
            return new Status(4, "com.atmel.avr32.target", Messages.DaisyChainPage_Bits_Before_Illegal);
        }
        if (!this.validNumber(this.bitsAfter.getText())) {
            return new Status(4, "com.atmel.avr32.target", Messages.DaisyChainPage_Bits_After_Illegal);
        }
        return Status.OK_STATUS;
    }

    private boolean validNumber(String text) {
        try {
            Integer value = Integer.parseInt(text, 10);
            if (value >= 0 && value <= this.maxDaisyChainValue) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return false;
    }
}

