/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal;

import com.atmel.avr32.target.internal.TargetPropertySource;
import com.atmel.avr32.target.tool.model.Interface;
import com.atmel.avr32.target.tool.model.Tool;
import com.atmel.avr32.target.ui.internal.AbstractToolSection;
import com.atmel.avr32.target.ui.internal.Messages;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ConnectionSection
extends AbstractToolSection {
    private CCombo targetAdapterConnection;
    private Label targetAdapterConnectionLabel;
    private Text targetAdapterSerial;
    private Text targetAdapterComport;
    private Label targetAdapterSerialLabel;
    private Label targetAdapterComportLabel;
    ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
    private final ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            TargetPropertySource properties = ConnectionSection.this.getTargetProperties();
            if (arg0.getSource().equals(ConnectionSection.this.targetAdapterSerial)) {
                properties.setPropertyValue("target.serial", ConnectionSection.this.targetAdapterSerial.getText());
            }
            if (arg0.getSource().equals(ConnectionSection.this.targetAdapterComport)) {
                properties.setPropertyValue("target.comport", ConnectionSection.this.targetAdapterComport.getText());
            }
            if (arg0.getSource().equals(ConnectionSection.this.targetAdapterConnection)) {
                properties.setPropertyValue("target.connection", ConnectionSection.this.targetAdapterConnection.getText());
            }
            ConnectionSection.this.validate();
        }
    };
    private ControlDecoration targetAdapterComportDecoration;
    private ControlDecoration targetAdapterSerialDecoration;

    private void validate() {
        if (this.targetAdapterComport.getText().length() == 0 && this.targetAdapterConnection.getText().equals("rs232")) {
            this.targetAdapterComportDecoration.setImage(standardError.getImage());
            this.targetAdapterComportDecoration.setDescriptionText(Messages.ConnectionSection_MissingPortError);
            this.targetAdapterComportDecoration.show();
        } else {
            this.targetAdapterComportDecoration.hide();
        }
        if (this.targetAdapterSerial.getText().length() == 0) {
            this.targetAdapterSerialDecoration.setImage(standardWarning.getImage());
            this.targetAdapterSerialDecoration.setDescriptionText(Messages.ConnectionSection_MissingSerialWarning);
            this.targetAdapterSerialDecoration.show();
        } else {
            this.targetAdapterSerialDecoration.hide();
        }
    }

    public ConnectionSection(Composite parent, String title, TabbedPropertySheetWidgetFactory toolkit) {
        super(parent, title, toolkit);
    }

    public ConnectionSection(Composite parent, String title, TabbedPropertySheetWidgetFactory toolkit, Control above) {
        super(parent, title, toolkit, above);
    }

    @Override
    protected void applyValues() {
    }

    @Override
    protected void clearValues() {
    }

    @Override
    public void createControls(Composite composite) {
        if (this.getTool().getInterfaces().size() > 0) {
            this.targetAdapterSerialLabel = this.getToolkit().createLabel(composite, Messages.ConnectionSection_SerialLabel);
            this.targetAdapterSerial = this.getToolkit().createText(composite, "");
            this.targetAdapterSerialLabel.setLayoutData((Object)this.createLabelGridData());
            this.targetAdapterSerial.setLayoutData((Object)this.createTextGridData());
            this.targetAdapterSerial.addModifyListener(this.listener);
            this.targetAdapterConnectionLabel = this.getToolkit().createLabel(composite, Messages.ConnectionSection_ConnectionLabel);
            this.targetAdapterConnection = this.getToolkit().createCCombo(composite, 8);
            this.targetAdapterConnectionLabel.setLayoutData((Object)this.createLabelGridData());
            this.targetAdapterConnection.setLayoutData((Object)this.createTextGridData());
            this.targetAdapterConnection.addModifyListener(this.listener);
            this.targetAdapterComportLabel = this.getToolkit().createLabel(composite, Messages.ConnectionSection_PortLabel);
            this.targetAdapterComport = this.getToolkit().createText(composite, "");
            this.targetAdapterComportLabel.setLayoutData((Object)this.createLabelGridData());
            this.targetAdapterComport.setLayoutData((Object)this.createTextGridData());
            this.targetAdapterComport.addModifyListener(this.listener);
            this.targetAdapterComportDecoration = new ControlDecoration((Control)this.targetAdapterComport, 16512);
            this.targetAdapterSerialDecoration = new ControlDecoration((Control)this.targetAdapterSerial, 16512);
            this.updateControls();
            this.validate();
        } else {
            Label l = this.getToolkit().createLabel(composite, Messages.ConnectionSection_NoConnections);
            l.setLayoutData((Object)this.createTextGridData());
        }
    }

    @Override
    protected void readValues() {
    }

    private TargetPropertySource getTargetProperties() {
        TargetPropertySource properties = (TargetPropertySource)this.getTarget().getAdapter(IPropertySource.class);
        return properties;
    }

    private void updateControls() {
        TargetPropertySource properties = this.getTargetProperties();
        if (this.targetAdapterSerial != null && !this.targetAdapterSerial.isDisposed()) {
            this.targetAdapterSerial.removeModifyListener(this.listener);
            this.targetAdapterSerial.setText((String)properties.getPropertyValue("target.serial"));
            this.targetAdapterSerial.addModifyListener(this.listener);
        }
        if (this.targetAdapterComport != null && !this.targetAdapterComport.isDisposed()) {
            this.targetAdapterComport.removeModifyListener(this.listener);
            this.targetAdapterComport.setText((String)properties.getPropertyValue("target.comport"));
            this.targetAdapterComport.addModifyListener(this.listener);
        }
        if (this.targetAdapterConnection != null && !this.targetAdapterConnection.isDisposed()) {
            this.targetAdapterConnection.removeModifyListener(this.listener);
            this.targetAdapterConnection.removeAll();
            for (Interface tool : this.getTool().getInterfaces()) {
                this.targetAdapterConnection.add(tool.getType());
            }
            this.targetAdapterConnection.setText((String)properties.getPropertyValue("target.connection"));
            this.targetAdapterConnection.addModifyListener(this.listener);
        }
    }

    @Override
    public void setTool(Tool tool) {
        super.setTool(tool);
        this.updateControls();
    }
}

