/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal;

import com.atmel.avr32.target.ITargetAlgorithmAdapter;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.tool.model.Clock;
import com.atmel.avr32.target.tool.model.Tool;
import com.atmel.avr32.target.ui.internal.AbstractToolSection;
import com.atmel.avr32.util.math.SIPrefixParser;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ClockSection
extends AbstractToolSection {
    HashMap<String, Scale> scales;
    HashMap<String, Text> texts;
    private static final String HZ = "Hz";
    Clock[] clocks;
    int role;

    @Override
    public void setTool(Tool tool) {
        this.clocks = tool != null ? tool.getClocks() : new Clock[0];
        super.setTool(tool);
    }

    public ClockSection(Composite parent, String title, TabbedPropertySheetWidgetFactory toolkit, int role) {
        super(parent, title, toolkit);
    }

    public ClockSection(Composite parent, String title, TabbedPropertySheetWidgetFactory toolkit, Control above, int role) {
        super(parent, title, toolkit, above);
        this.scales = new HashMap();
        this.texts = new HashMap();
        this.clocks = new Clock[0];
        this.role = role;
    }

    @Override
    public void createControls(Composite composite) {
        boolean allClocksAreReadOnly = true;
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        GridData ld = new GridData();
        ld.widthHint = 60;
        Clock[] clockArray = this.clocks;
        int n = this.clocks.length;
        int n2 = 0;
        while (n2 < n) {
            final Clock clock = clockArray[n2];
            if (clock.isWritable()) {
                allClocksAreReadOnly = false;
            }
            final ITargetAlgorithmAdapter alg = this.getTool().getAlgorithm(clock.getId());
            CLabel label = this.getToolkit().createCLabel(composite, clock.getName());
            label.setLayoutData((Object)this.createLabelGridData());
            final Scale scale = new Scale(composite, 0);
            scale.setBackground(this.getToolkit().getColors().getBackground());
            scale.setMaximum((int)clock.getMaxFrequency() / 1000);
            scale.setMinimum((int)clock.getMinFrequency() / 1000);
            scale.setIncrement((int)clock.getMaxFrequency() / 50 / 1000);
            scale.setPageIncrement((int)clock.getMaxFrequency() / 50 / 1000);
            scale.setLayoutData((Object)gd);
            this.scales.put(clock.getId(), scale);
            final Text text = this.getToolkit().createText(composite, String.valueOf(SIPrefixParser.getString((float)clock.getValue())) + HZ, 131072);
            text.setLayoutData((Object)ld);
            this.texts.put(clock.getId(), text);
            if (!clock.isWritable()) {
                scale.setEnabled(false);
                text.setEnabled(false);
            }
            text.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    switch (e.detail) {
                        case 4: 
                        case 8: 
                        case 16: {
                            int value = SIPrefixParser.getInt((String)text.getText());
                            value = (int)alg.calculateValue(value);
                            scale.setSelection(value / 1000);
                            text.setText(String.valueOf(SIPrefixParser.getString((float)value)) + ClockSection.HZ);
                            clock.setValue(value);
                            ClockSection.this.setStatus(alg.testValue(value));
                        }
                    }
                }
            });
            scale.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    int value = (int)alg.calculateValue(scale.getSelection() * 1000);
                    text.setText(String.valueOf(SIPrefixParser.getString((float)value)) + ClockSection.HZ);
                    clock.setValue(value);
                    ClockSection.this.setStatus(alg.testValue(scale.getSelection() * 1000));
                }
            });
            ++n2;
        }
        if (this.clocks.length > 0) {
            this.createButtons(composite, allClocksAreReadOnly);
        } else {
            Label l = this.getToolkit().createLabel(composite, "This programmer/debugger does not have controllable clocks.");
            l.setLayoutData((Object)gd);
        }
    }

    @Override
    protected void applyValues() {
        ITargetInterface adapter = TargetPlugin.getDefault().getTargetInterface(this.getTarget(), false);
        if (adapter == null) {
            return;
        }
        adapter.setTarget(this.getTarget());
        Clock[] clockArray = this.clocks;
        int n = this.clocks.length;
        int n2 = 0;
        while (n2 < n) {
            Clock clock = clockArray[n2];
            IStatus status = adapter.setClockFrequency(clock);
            if (status.isOK()) {
                ErrorDialog.openError((Shell)this.getControl().getShell(), (String)"Error", (String)("Could not set clock freqency " + clock.getId() + "."), (IStatus)status);
            }
            ++n2;
        }
    }

    @Override
    protected void readValues() {
        ITargetInterface adapter = TargetPlugin.getDefault().getTargetInterface(this.getTarget(), false);
        if (adapter == null) {
            return;
        }
        adapter.setTarget(this.getTarget());
        Clock[] clockArray = this.clocks;
        int n = this.clocks.length;
        int n2 = 0;
        while (n2 < n) {
            Clock clock = clockArray[n2];
            IStatus status = adapter.applyClockFrequency(clock);
            Scale scale = this.scales.get(clock.getId());
            Text text = this.texts.get(clock.getId());
            if (status.isOK()) {
                scale.setSelection((int)(clock.getValue() / 1000.0f));
                text.setText(String.valueOf(SIPrefixParser.getString((float)clock.getValue())) + HZ);
            } else {
                scale.setSelection(0);
                text.setText("");
                ErrorDialog.openError((Shell)this.getControl().getShell(), (String)"Error", (String)("Could not read clock frequency " + clock.getId() + "."), (IStatus)status);
            }
            ++n2;
        }
    }

    @Override
    protected void clearValues() {
        Clock[] clockArray = this.clocks;
        int n = this.clocks.length;
        int n2 = 0;
        while (n2 < n) {
            Scale scale;
            Clock clock = clockArray[n2];
            clock.setValue(0.0f);
            Text text = this.texts.get(clock.getId());
            if (text != null && !text.isDisposed()) {
                text.setText(String.valueOf(SIPrefixParser.getString((float)0.0f)) + HZ);
            }
            if ((scale = this.scales.get(clock.getId())) != null && !scale.isDisposed()) {
                scale.setSelection(0);
            }
            ++n2;
        }
    }
}

