/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal;

import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.tool.model.Tool;
import com.atmel.avr32.target.ui.internal.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class AbstractToolSection {
    private static final String EMPTY_STRING = "";
    protected static FieldDecoration standardError = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
    protected static FieldDecoration standardWarning = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_WARNING");
    protected static FieldDecoration standardInformation = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");
    private Tool fTool;
    private ITarget fTarget;
    private Composite composite;
    private final TabbedPropertySheetWidgetFactory toolkit;
    private Section section;
    private Button read;
    private Button apply;
    private CLabel statusText = null;
    ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
    private EventHandler handler;

    public AbstractToolSection(Composite parent, String title, TabbedPropertySheetWidgetFactory toolkit) {
        this.toolkit = toolkit;
        this.createControls(parent, title);
    }

    public AbstractToolSection(Composite parent, String title, TabbedPropertySheetWidgetFactory toolkit, Control above) {
        this(parent, title, toolkit);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(above, 4);
        this.section.setLayoutData((Object)data);
    }

    protected abstract void createControls(Composite var1);

    private void createControls(Composite parent, String name) {
        this.section = this.toolkit.createSection(parent, 322);
        this.section.setText(name);
        this.composite = this.toolkit.createComposite((Composite)this.section);
        FormData fd = new FormData();
        this.composite.setLayoutData((Object)fd);
        GridLayout gl = GridLayoutFactory.fillDefaults().create();
        gl.marginRight = 4;
        gl.marginTop = 4;
        gl.marginBottom = 4;
        gl.numColumns = 3;
        this.composite.setLayout((Layout)gl);
        this.section.setClient((Control)this.composite);
    }

    public Tool getTool() {
        return this.fTool;
    }

    private void refresh() {
        Control[] controlArray = this.composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.composite.pack(true);
        if (this.fTool != null) {
            this.createControls(this.composite);
        } else {
            Label l = new Label(this.composite, 0);
            l.setText(Messages.AbstractToolSection_NoData);
        }
        this.composite.layout();
        this.section.layout();
        this.section.getParent().layout();
    }

    public void setTool(Tool tool) {
        if (this.fTool == null || !this.fTool.equals(tool)) {
            this.fTool = tool;
            this.refresh();
        }
        if (this.fTool != null) {
            this.clearValues();
        }
    }

    public void setTarget(ITarget target) {
        this.fTarget = target;
    }

    public ITarget getTarget() {
        return this.fTarget;
    }

    public TabbedPropertySheetWidgetFactory getToolkit() {
        return this.toolkit;
    }

    public Section getControl() {
        return this.section;
    }

    protected void createButtons(Composite composite, boolean readOnly) {
        this.handler = new EventHandler();
        Composite c = this.getToolkit().createComposite(composite);
        GridData cc = new GridData(768);
        cc.horizontalSpan = 3;
        c.setLayoutData((Object)cc);
        c.setLayout((Layout)new FormLayout());
        this.read = this.getToolkit().createButton(c, Messages.AbstractToolSection_Read, 8);
        this.apply = this.getToolkit().createButton(c, Messages.AbstractToolSection_Apply, 8);
        this.apply.setEnabled(!readOnly);
        FormData fd = new FormData();
        fd.left = new FormAttachment((Control)this.read, 5);
        this.apply.setLayoutData((Object)fd);
        this.read.addListener(13, (Listener)this.handler);
        this.apply.addListener(13, (Listener)this.handler);
        this.statusText = this.getToolkit().createCLabel(c, EMPTY_STRING);
        FormData fd2 = new FormData();
        fd2.left = new FormAttachment((Control)this.apply, 5);
        fd2.right = new FormAttachment(100);
        this.statusText.setLayoutData((Object)fd2);
    }

    protected void setStatus(IStatus status) {
        if (status.isOK()) {
            this.statusText.setImage(null);
            this.statusText.setText(EMPTY_STRING);
        } else {
            this.statusText.setText(status.getMessage());
            if (status.getSeverity() == 2) {
                this.statusText.setImage(this.images.getImage("IMG_OBJS_WARN_TSK"));
            }
        }
    }

    protected abstract void applyValues();

    protected abstract void readValues();

    protected abstract void clearValues();

    protected GridData createLabelGridData() {
        GridData ld = new GridData();
        ld.widthHint = 85;
        ld.verticalIndent = 4;
        return ld;
    }

    protected GridData createTextGridData() {
        GridData td = new GridData(768);
        td.horizontalSpan = 2;
        td.grabExcessHorizontalSpace = true;
        td.verticalIndent = 4;
        td.horizontalIndent = 8;
        return td;
    }

    private class EventHandler
    implements Listener {
        private EventHandler() {
        }

        public void handleEvent(Event event) {
            if (event.widget.equals(AbstractToolSection.this.read)) {
                AbstractToolSection.this.readValues();
            }
            if (event.widget.equals(AbstractToolSection.this.apply)) {
                AbstractToolSection.this.applyValues();
            }
        }
    }
}

