/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.internal;

import com.atmel.avr32.target.Target;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.internal.TargetPropertySource;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;

public abstract class AbstractTargetPropertyPage
extends AbstractPropertySection
implements IHyperlinkListener {
    private static final String HTTP_LINK_PROTOCOL = "http://";
    private static final String HELP_LINK_PROTOCOL = "help://";
    private Target targetDescription;

    protected Hyperlink addPartDescriptionLink(Composite container, FormToolkit toolkit, String text) {
        ImageHyperlink link = toolkit.createImageHyperlink(container, 64);
        link.setText(text);
        return link;
    }

    protected void handleLinkActivated(String link) {
        if (link.startsWith(HELP_LINK_PROTOCOL)) {
            this.displayHelpResource(link.substring(6));
        }
        if (link.startsWith(HTTP_LINK_PROTOCOL)) {
            try {
                PlatformUI.getWorkbench().getBrowserSupport().createBrowser("wiki").openURL(new URL(link));
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    protected Link addLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setText(text);
        return link;
    }

    protected FormText addFormText(Composite composite, String text) {
        FormText ft = this.getWidgetFactory().createFormText(composite, true);
        ft.setText(text, true, false);
        ft.setWhitespaceNormalized(true);
        ft.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractTargetPropertyPage.this.handleLinkActivated(e.data.toString());
            }
        });
        return ft;
    }

    protected void addHelpLink(Section section, final String url) {
        ImageHyperlink info = new ImageHyperlink((Composite)section, 0);
        this.getWidgetFactory().adapt((Control)info, false, false);
        info.setImage(TargetPlugin.getDefault().getImageRegistry().get("IMAGE_DESC_HELP"));
        info.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractTargetPropertyPage.this.displayHelpResource(url);
            }
        });
        info.setBackground(this.getWidgetFactory().getColors().getBackground());
        section.setTextClient((Control)info);
    }

    private void displayHelpResource(String resource) {
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(resource);
    }

    public void linkActivated(HyperlinkEvent e) {
    }

    public void linkEntered(HyperlinkEvent e) {
    }

    public void linkExited(HyperlinkEvent e) {
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof Target));
        if (this.targetDescription == null || !this.targetDescription.equals(input)) {
            this.targetDescription = (Target)input;
            this.refresh();
        }
    }

    protected TargetPropertySource getTargetProperties() {
        return (TargetPropertySource)this.getTargetDescription().getAdapter(IPropertySource.class);
    }

    protected Target getTargetDescription() {
        return this.targetDescription;
    }
}

