/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.composites;

import com.atmel.avr32.target.ui.AbstractTargetActionComposite;
import com.atmel.avr32.target.ui.composites.Messages;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;

public abstract class FileDialogComposite
extends AbstractTargetActionComposite {
    private static final String STRING = "length";
    private static final String DATA_FORMAT = "format";
    private static final String DATA_FULL_LENGTH = "fullLength";
    private static final String DATA_OFFSET = "offset";
    private static final String DATA_FILEPATH = "filepath";
    protected int style;
    protected static final int PATH = 0;
    protected static final int LENGTH = 1;
    protected static final int ENTIRE_FILE = 2;
    protected static final int OFFSET = 4;
    protected static final int FILE_FORMAT = 8;
    protected static final int WORKSPACE = 16;
    protected static final int SAVE = 32;
    ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
    private Label label = null;
    private Label label1 = null;
    private Label label2 = null;
    private Label label3 = null;
    protected Text offsetText = null;
    protected Text lengthText = null;
    private Combo formatCombo = null;
    private Text filenameText = null;
    private Button browseButton = null;
    protected Button entireFileCheckbox = null;
    protected long offset = 0L;
    protected long length = 255L;
    protected String fileName;
    protected String fileFormat;
    protected boolean complete;

    public FileDialogComposite(Composite parent) {
        this(parent, 0);
    }

    public FileDialogComposite(Composite parent, int style) {
        super(parent, 0);
        GridData gd = new GridData();
        this.setLayoutData(gd);
        this.style = style;
        this.initialize();
    }

    void initialize() {
        GridData grabAll = new GridData();
        grabAll.horizontalSpan = 3;
        grabAll.grabExcessVerticalSpace = true;
        grabAll.horizontalAlignment = 4;
        grabAll.verticalAlignment = 4;
        grabAll.grabExcessHorizontalSpace = true;
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.minimumWidth = 200;
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        GridData gridData1 = new GridData();
        gridData1.horizontalAlignment = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.createFileField(gridData1, gridData4);
        if ((this.style & 8) == 8 && this.getFileFormats().length > 0) {
            this.createFormatField(gridData4);
        }
        if ((this.style & 4) == 4) {
            this.createOffsetGroup(gridData2, gridData1);
        }
        if ((this.style & 1) == 1) {
            this.createLengthGroup(gridData2, gridData1);
        }
        this.setLayout((Layout)gridLayout);
    }

    private void createFileField(GridData buttonGd, GridData textGd) {
        this.label3 = new Label((Composite)this, 0);
        this.label3.setText(Messages.FileDialogComposite_File_Path);
        this.filenameText = new Text((Composite)this, 2048);
        this.filenameText.setLayoutData((Object)textGd);
        this.filenameText.setData((Object)DATA_FILEPATH);
        this.filenameText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FileDialogComposite.this.fileName = FileDialogComposite.this.filenameText.getText();
                FileDialogComposite.this.firePropertyChange(new PropertyChangeEvent((Object)FileDialogComposite.this.filenameText, "DIALOG", null, null));
                if (!FileDialogComposite.this.filenameText.isFocusControl()) {
                    FileDialogComposite.this.filenameText.setSelection(FileDialogComposite.this.fileName.length());
                }
            }
        });
        this.browseButton = new Button((Composite)this, 0);
        this.browseButton.setText(Messages.FileDialogComposite_Browse);
        this.browseButton.setLayoutData((Object)buttonGd);
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                Shell shell = window.getShell();
                FileDialogComposite.this.fileName = (FileDialogComposite.this.style & 0x10) == 16 ? FileDialogComposite.this.selectResource(shell) : FileDialogComposite.this.selectNative(shell);
                if (FileDialogComposite.this.fileName != null) {
                    FileDialogComposite.this.filenameText.setText(FileDialogComposite.this.fileName);
                    FileDialogComposite.this.firePropertyChange(new PropertyChangeEvent((Object)FileDialogComposite.this.filenameText, "DIALOG", null, null));
                } else {
                    FileDialogComposite.this.fileName = FileDialogComposite.this.filenameText.getText();
                    FileDialogComposite.this.firePropertyChange(new PropertyChangeEvent((Object)FileDialogComposite.this.filenameText, "DIALOG", null, null));
                }
            }
        });
    }

    private void createFormatField(GridData gridData4) {
        this.label2 = new Label((Composite)this, 0);
        this.label2.setText(Messages.FileDialogComposite_File_Format);
        this.createCombo();
    }

    private void createOffsetGroup(GridData gridData2, GridData gridData1) {
        this.label = new Label((Composite)this, 0);
        this.label.setText(Messages.FileDialogComposite_Offset_Address);
        this.offsetText = new Text((Composite)this, 2048);
        this.offsetText.setLayoutData((Object)gridData2);
        this.offsetText.setText(Messages.FileDialogComposite_Start_Address);
        this.offsetText.setData((Object)DATA_OFFSET);
        this.offsetText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FileDialogComposite.this.offset = FileDialogComposite.this.getLong(FileDialogComposite.this.offsetText);
                FileDialogComposite.this.firePropertyChange(new PropertyChangeEvent((Object)FileDialogComposite.this.offsetText, "DIALOG", null, null));
            }
        });
    }

    private void createLengthGroup(GridData gridData2, GridData gridData1) {
        this.label1 = new Label((Composite)this, 0);
        this.label1.setText(Messages.FileDialogComposite_Number_of_Bytes);
        this.lengthText = new Text((Composite)this, 2048);
        this.lengthText.setText(Messages.FileDialogComposite_Length);
        this.lengthText.setData((Object)STRING);
        if ((this.style & 2) != 0) {
            this.entireFileCheckbox = new Button((Composite)this, 32);
            this.entireFileCheckbox.setText("Entire file");
            this.entireFileCheckbox.setData((Object)DATA_FULL_LENGTH);
            this.entireFileCheckbox.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    FileDialogComposite.this.complete = FileDialogComposite.this.entireFileCheckbox.getSelection();
                    FileDialogComposite.this.lengthText.setEnabled(!FileDialogComposite.this.complete);
                    FileDialogComposite.this.firePropertyChange(new PropertyChangeEvent((Object)FileDialogComposite.this.complete, "DIALOG", null, null));
                    FileDialogComposite.this.firePropertyChange(new PropertyChangeEvent((Object)FileDialogComposite.this.lengthText, "DIALOG", null, null));
                }
            });
            this.lengthText.setLayoutData((Object)gridData1);
            this.complete = true;
            this.lengthText.setEnabled(!this.complete);
            this.entireFileCheckbox.setSelection(true);
        } else {
            this.lengthText.setLayoutData((Object)gridData2);
        }
        this.lengthText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FileDialogComposite.this.length = FileDialogComposite.this.getLong(FileDialogComposite.this.lengthText);
                FileDialogComposite.this.firePropertyChange(new PropertyChangeEvent((Object)FileDialogComposite.this.lengthText, "DIALOG", null, null));
            }
        });
    }

    private void createCombo() {
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.formatCombo = new Combo((Composite)this, 8);
        this.formatCombo.setLayoutData((Object)gridData);
        String[] stringArray = this.getFileFormats();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            this.formatCombo.add(format);
            ++n2;
        }
        this.formatCombo.setText(this.getFileFormats()[0]);
        this.fileFormat = this.getFileFormats()[0];
        this.formatCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FileDialogComposite.this.fileFormat = FileDialogComposite.this.formatCombo.getText();
                FileDialogComposite.this.firePropertyChange(new PropertyChangeEvent((Object)FileDialogComposite.this.filenameText, "DIALOG", null, null));
            }
        });
        this.formatCombo.setData((Object)DATA_FORMAT);
    }

    private long getLong(Text text) {
        long value = 0L;
        String newText = text.getText();
        if (newText.startsWith("0x")) {
            try {
                value = Long.parseLong(newText.substring(2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                this.getDialog().setErrorMessage(Messages.FileDialogComposite_Bad_Address);
                return -1L;
            }
        }
        if (newText.length() > 0) {
            try {
                value = Long.parseLong(newText);
            }
            catch (NumberFormatException numberFormatException) {
                this.getDialog().setErrorMessage(Messages.FileDialogComposite_Enter_Address);
                return -1L;
            }
        }
        return value;
    }

    @Override
    public boolean validate() {
        if ((this.style & 1) == 1 && !this.complete) {
            if (this.length == 0L) {
                this.getDialog().setErrorMessage(Messages.FileDialogComposite_Bad_Length);
                return false;
            }
            if (this.getLong(this.lengthText) == -1L) {
                this.getDialog().setErrorMessage(Messages.FileDialogComposite_Bad_Length);
                return false;
            }
        }
        if ((this.style & 4) == 4 && this.getLong(this.offsetText) == -1L) {
            return false;
        }
        if (this.fileName == null || this.fileName.length() == 0) {
            this.getDialog().setErrorMessage(Messages.FileDialogComposite_Missing_Filename);
            return false;
        }
        this.getDialog().setErrorMessage(null);
        return true;
    }

    protected abstract String[] getFileFormats();

    protected String[] getFileNameSuffixes() {
        return new String[0];
    }

    private String selectNative(Shell shell) {
        FileDialog fd = new FileDialog(shell, (this.style & 0x20) == 32 ? 8192 : 0);
        fd.setFilterExtensions(this.getFileNameSuffixes());
        fd.setFilterPath(null);
        fd.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString());
        try {
            File f = new File(this.filenameText.getText());
            if (f.getParentFile() != null && f.getParentFile().exists()) {
                fd.setFilterPath(f.getParent());
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return fd.open();
    }

    private String selectResource(Shell shell) {
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        if ((this.style & 0x20) != 32) {
            OpenResourceDialog rd = new OpenResourceDialog(shell, (IContainer)input, 1);
            if (rd.open() == 0) {
                return ((IResource)rd.getFirstResult()).getFullPath().toOSString();
            }
        } else {
            SaveAsDialog rd = new SaveAsDialog(shell);
            if (this.filenameText.getText().length() > 0) {
                try {
                    IFile path = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.filenameText.getText()));
                    if (path.exists()) {
                        rd.setOriginalFile(path);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (rd.open() == 0) {
                return rd.getResult().toOSString();
            }
        }
        return null;
    }

    public class OpenResourceDialog
    extends FilteredResourcesSelectionDialog {
        public OpenResourceDialog(Shell parentShell, IContainer container, int typesMask) {
            super(parentShell, false, container, typesMask);
            this.setTitle("Open Workspace File");
            if (FileDialogComposite.this.getFileNameSuffixes().length == 1) {
                this.setInitialPattern(FileDialogComposite.this.getFileNameSuffixes()[0]);
            } else {
                this.setInitialPattern("*.*");
            }
        }
    }
}

