/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui.composites;

import com.atmel.avr32.target.ui.AbstractTargetActionComposite;
import com.atmel.avr32.target.ui.composites.Messages;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class AddressDialogComposite
extends AbstractTargetActionComposite {
    private static final String EMPTY_STRING = "";
    private static final String HEX_PREFIX = "0x";
    private static final String HEX_ZERO = "0x0";
    ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
    private Label label = null;
    private Text text = null;
    private CLabel cLabel = null;
    private long offset = 0L;

    public AddressDialogComposite(Composite parent) {
        super(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        this.setLayoutData(gd);
        this.initialize();
    }

    private void initialize() {
        GridData gridData = new GridData(4, 4, true, false);
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 3;
        gridData3.grabExcessVerticalSpace = true;
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.label = new Label((Composite)this, 0);
        this.label.setText(Messages.AddressDialogComposite_Address);
        this.text = new Text((Composite)this, 2048);
        this.text.setLayoutData((Object)gridData2);
        this.text.setText(HEX_ZERO);
        this.text.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                AddressDialogComposite.this.offset = AddressDialogComposite.this.isValid(AddressDialogComposite.this.text.getText());
                AddressDialogComposite.this.firePropertyChange(new PropertyChangeEvent((Object)AddressDialogComposite.this.text, "DIALOG", null, null));
            }
        });
        this.text.setLayoutData((Object)gridData);
        this.cLabel = new CLabel((Composite)this, 0);
        this.cLabel.setText(EMPTY_STRING);
        this.cLabel.setLayoutData((Object)gridData3);
        this.setLayout((Layout)gridLayout);
        this.validate();
    }

    private long isValid(String newText) {
        long value = 0L;
        if (newText.startsWith(HEX_PREFIX)) {
            try {
                value = Long.parseLong(newText.substring(2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                this.cLabel.setImage(this.images.getImage("IMG_OBJS_ERROR_TSK"));
                this.cLabel.setText(Messages.AddressDialogComposite_AddressError_1);
                return -1L;
            }
        }
        try {
            value = Long.parseLong(newText);
        }
        catch (NumberFormatException numberFormatException) {
            this.cLabel.setImage(this.images.getImage("IMG_OBJS_ERROR_TSK"));
            this.cLabel.setText(Messages.AddressDialogComposite_AddressError_2);
            return -1L;
        }
        this.cLabel.setImage(null);
        this.cLabel.setText(EMPTY_STRING);
        return value;
    }

    @Override
    public boolean validate() {
        this.cLabel.setText(EMPTY_STRING);
        this.cLabel.setImage(null);
        return true;
    }

    @Override
    public Object[] getOptions() {
        return new Object[]{"-O", new Long(this.offset)};
    }
}

