/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui;

import com.atmel.avr32.target.FuseRegisterSettings;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.TargetJob;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.ui.TargetActionDialog;
import com.atmel.avr32.target.ui.TargetDialogAction;
import com.atmel.avr32.target.ui.composites.WriteFusesDialogComposite;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class WriteFusesAction
extends TargetDialogAction {
    @Override
    public void run() {
        TargetActionDialog rd;
        final ITargetInterface adapter = TargetPlugin.getDefault().getTargetInterface(this);
        if (adapter == null) {
            return;
        }
        adapter.setTarget(this.fSelectedTarget);
        IStatus ok = TargetPlugin.getTargetManager().validateOperation(this.getTarget(), 1);
        if (!ok.isOK()) {
            TargetPlugin.operationStatusMessage(ok);
            return;
        }
        Shell shell = TargetPlugin.getStandardDisplay().getActiveShell();
        if (shell == null) {
            shell = new Shell(new Display());
        }
        if ((rd = new TargetActionDialog(this, shell)).open() == 1) {
            return;
        }
        final String filepath = ((WriteFusesDialogComposite)this.getComposite()).getFileName();
        TargetJob job = new TargetJob(this.getDescription()){

            public IStatus run(IProgressMonitor monitor) {
                try {
                    FuseRegisterSettings fs = new FuseRegisterSettings((IPath)new Path(filepath));
                    IStatus status = adapter.applyFuseSettings(fs, monitor);
                    if (status.getSeverity() == 2) {
                        TargetPlugin.warningMessage("Could not execute action", status.getMessage());
                    }
                    return status;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return null;
            }
        };
        job.setTarget(this.fSelectedTarget);
        job.setPriority(10);
        job.setUser(this.showProgress);
        job.schedule();
    }
}

