/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui;

import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.TargetPlugin;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class TargetImageProvider {
    public Image getImage(ITarget target) {
        int flags = 0;
        if (!target.isValid()) {
            flags |= 1;
        }
        if (target.isWorking()) {
            flags |= 2;
        }
        if (target.isDefault()) {
            flags |= 8;
        }
        Image base = target.getIcon().createImage();
        OverlayedTargetIcon icon = new OverlayedTargetIcon(base, flags);
        return icon.createImage();
    }

    private class OverlayedTargetIcon
    extends CompositeImageDescriptor {
        public static final int INVALID = 1;
        public static final int WORKING = 2;
        public static final int DEFAULT = 8;
        private Image fBaseImage;
        private int fFlags;
        private Point fSize;

        public OverlayedTargetIcon(Image baseImage, int flags) {
            this.setBaseImage(baseImage);
            this.setFlags(flags);
        }

        protected Point getSize() {
            if (this.fSize == null) {
                ImageData data = this.getBaseImage().getImageData();
                this.setSize(new Point(data.width, data.height));
            }
            return this.fSize;
        }

        public boolean equals(Object object) {
            if (!(object instanceof OverlayedTargetIcon)) {
                return false;
            }
            OverlayedTargetIcon other = (OverlayedTargetIcon)((Object)object);
            return this.getBaseImage().equals((Object)other.getBaseImage()) && this.getFlags() == other.getFlags();
        }

        public int hashCode() {
            return this.getBaseImage().hashCode() | this.getFlags();
        }

        protected void drawCompositeImage(int width, int height) {
            ImageData bg = this.getBaseImage().getImageData();
            if (bg == null) {
                bg = DEFAULT_IMAGE_DATA;
            }
            this.drawImage(bg, 0, 0);
            this.drawOverlays();
        }

        protected void drawOverlays() {
            int flags = this.getFlags();
            int x = 0;
            int y = 0;
            ImageData data = null;
            if ((flags & 1) != 0) {
                x = 0;
                y = 0;
                data = TargetPlugin.getDefault().getImageRegistry().get("IMAGE_OVR_TGT_INVALID").getImageData();
                this.drawImage(data, x, y);
            }
            if ((flags & 2) != 0) {
                x = 0;
                y = 0;
                data = TargetPlugin.getDefault().getImageRegistry().get("IMAGE_OVR_TGT_WORKING").getImageData();
                this.drawImage(data, x, y);
            }
            if ((flags & 8) != 0) {
                x = 0;
                y = 4;
                data = TargetPlugin.getDefault().getImageRegistry().get("IMAGE_OVR_TGT_DEFAULT").getImageData();
                this.drawImage(data, x, y);
            }
        }

        protected Image getBaseImage() {
            return this.fBaseImage;
        }

        protected void setBaseImage(Image image) {
            this.fBaseImage = image;
        }

        protected int getFlags() {
            return this.fFlags;
        }

        protected void setFlags(int flags) {
            this.fFlags = flags;
        }

        protected void setSize(Point size) {
            this.fSize = size;
        }
    }
}

