/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui;

import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.TargetCommandStatus;
import com.atmel.avr32.target.TargetJob;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.ui.AbstractTargetActionComposite;
import com.atmel.avr32.target.ui.TargetAction;
import com.atmel.avr32.target.ui.TargetActionDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public class TargetDialogAction
extends TargetAction {
    AbstractTargetActionComposite composite;
    String className;
    String title;
    String bundleId;

    public void setComposite(String compositeClass) {
        this.className = compositeClass;
    }

    protected AbstractTargetActionComposite getComposite() {
        return this.composite;
    }

    @Override
    public void run() {
        try {
            TargetActionDialog rd;
            Shell shell = TargetPlugin.getStandardDisplay().getActiveShell();
            if (shell == null) {
                shell = new Shell(new Display());
            }
            if ((rd = new TargetActionDialog(this, shell)).open() == 1) {
                return;
            }
            final ITargetInterface adapter = TargetPlugin.getDefault().getTargetInterface(this);
            adapter.setTarget(this.getTarget());
            this.setOptions(this.composite.getOptions());
            final TargetDialogAction action = this;
            TargetJob job = new TargetJob(this.getDescription()){

                public IStatus run(IProgressMonitor monitor) {
                    String result;
                    TargetCommandStatus status = adapter.execute(action, monitor);
                    if (TargetDialogAction.this.showResult && (result = status.getResult()) != null) {
                        TargetPlugin.infoMessage(TargetDialogAction.this.getText(), result);
                    }
                    if (status.getSeverity() == 2) {
                        TargetPlugin.warningMessage("Could not execute action", status.getMessage());
                    }
                    return status;
                }
            };
            job.setTarget(this.fSelectedTarget);
            job.setPriority(10);
            job.setUser(this.showProgress);
            job.schedule();
        }
        catch (Exception e) {
            Status s = new Status(4, "com.atmel.avr32.target", "Could not execute command", (Throwable)e);
            StatusManager.getManager().handle((IStatus)s, 2);
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }
}

