/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui;

import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.ui.AbstractTargetActionComposite;
import com.atmel.avr32.target.ui.TargetDialogAction;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TargetActionDialog
extends TitleAreaDialog
implements IPropertyChangeListener {
    private final TargetDialogAction targetDialogAction;

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
        IDialogSettings root = TargetPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = root.getSection(this.getSectionName());
        if (settings == null) {
            settings = root.addNewSection(this.getSectionName());
        }
        this.readSettings(settings, this.targetDialogAction.composite);
        this.getButton(0).setEnabled(this.targetDialogAction.composite.validate());
    }

    private void readSettings(IDialogSettings settings, Composite root) {
        Control[] controls;
        Control[] controlArray = controls = root.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Group) {
                this.readSettings(settings, (Composite)control);
            } else {
                String value;
                Object key = control.getData();
                if (key != null && (value = settings.get((String)key)) != null) {
                    if (control instanceof Text) {
                        ((Text)control).setText(value);
                    }
                    if (control instanceof Combo) {
                        ((Combo)control).select(settings.getInt((String)key));
                        ((Combo)control).notifyListeners(24, new Event());
                    }
                    if (control instanceof Button) {
                        ((Button)control).setSelection(settings.getBoolean((String)key));
                        ((Button)control).notifyListeners(13, new Event());
                    }
                }
            }
            ++n2;
        }
    }

    public TargetActionDialog(TargetDialogAction targetDialogAction, Shell parent) {
        super(parent);
        this.targetDialogAction = targetDialogAction;
    }

    protected Control createDialogArea(Composite parent) {
        try {
            Class c = Platform.getBundle((String)this.targetDialogAction.bundleId).loadClass(this.targetDialogAction.className);
            Constructor constructor = c.getDeclaredConstructor(Composite.class);
            this.targetDialogAction.composite = (AbstractTargetActionComposite)((Object)constructor.newInstance(parent));
            this.targetDialogAction.composite.addPropertyChangeListener(this);
            this.targetDialogAction.composite.setTarget(this.targetDialogAction.fSelectedTarget);
            this.targetDialogAction.composite.setDialog(this);
            this.targetDialogAction.composite.setLayoutData(new GridData(1808));
            this.targetDialogAction.composite.setFont(parent.getFont());
            this.setTitleImage(TargetPlugin.getDefault().getImageRegistry().get("IMAGE_TARGET_ACTION_BANNER"));
            this.setTitle(this.targetDialogAction.getTarget().getName());
            this.setMessage(this.targetDialogAction.getDescription());
            this.targetDialogAction.composite.validate();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return this.targetDialogAction.composite;
    }

    protected void okPressed() {
        if (!this.targetDialogAction.composite.validate()) {
            return;
        }
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.targetDialogAction.title);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.getButton(0).setEnabled(this.targetDialogAction.composite.validate());
    }

    public boolean close() {
        IDialogSettings root = TargetPlugin.getDefault().getDialogSettings();
        IDialogSettings settings = root.getSection(this.getSectionName());
        if (settings == null) {
            settings = root.addNewSection(this.getSectionName());
        }
        this.storeSettings(settings, this.targetDialogAction.composite);
        return super.close();
    }

    private String getSectionName() {
        String section = String.valueOf(((Object)((Object)this.targetDialogAction.composite)).getClass().getCanonicalName()) + "." + this.targetDialogAction.getTarget().getId();
        return section;
    }

    private void storeSettings(IDialogSettings settings, Composite root) {
        Control[] controls;
        Control[] controlArray = controls = root.getChildren();
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Group) {
                this.storeSettings(settings, (Composite)control);
            } else {
                Object key = control.getData();
                if (key != null) {
                    if (control instanceof Text) {
                        settings.put((String)key, ((Text)control).getText());
                    }
                    if (control instanceof Combo) {
                        settings.put((String)key, ((Combo)control).getSelectionIndex());
                    }
                    if (control instanceof Button) {
                        settings.put((String)key, ((Button)control).getSelection());
                    }
                }
            }
            ++n2;
        }
    }
}

