/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui;

import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetAction;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.TargetCommandStatus;
import com.atmel.avr32.target.TargetJob;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.tool.model.Capability;
import com.atmel.avr32.target.ui.Messages;
import com.atmel.avr32.target.ui.ResultDialog;
import com.atmel.avr32.util.UtilPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TargetAction
extends Action
implements ITargetAction {
    private static final FontRegistry fr = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry();
    private ArrayList<Capability> requirements;
    protected String fInterfaceId = "";
    boolean fFillMenu;
    private ITargetAction.TargetComponent appliesTo;
    private int position;
    IStructuredSelection fSelection;
    protected Object[] fOptions;
    protected boolean submenu;
    protected String fCommand;
    protected ITarget fSelectedTarget;
    protected boolean needsConnection = true;
    protected boolean showResult = false;
    protected boolean showProgress = false;
    private String helpContextId = null;

    public TargetAction() {
    }

    public TargetAction(String text) {
        super(text);
    }

    public TargetAction(String text, boolean needsConnection, boolean showDialog) {
        super(text);
        this.needsConnection = needsConnection;
        this.showProgress = showDialog;
    }

    public void setRequirements(ArrayList<Capability> requirements) {
        this.requirements = requirements;
    }

    @Override
    public ArrayList<Capability> getRequirements() {
        return this.requirements;
    }

    public void run() {
        if (this.fSelectedTarget == null) {
            TargetPlugin.errorMessage(Messages.TargetAction_CannotExecute, Messages.TargetAction_MissingTarget);
            return;
        }
        final ITargetInterface adapter = TargetPlugin.getDefault().getTargetInterface(this);
        adapter.setTarget(this.getTarget());
        if (adapter == null) {
            UtilPlugin.error((Object)MessageFormat.format(Messages.TargetAction_NoInterface, this.getDescription()));
            return;
        }
        final TargetAction action = this;
        TargetJob job = new TargetJob(this.getDescription()){

            public IStatus run(IProgressMonitor monitor) {
                String result;
                TargetCommandStatus status = adapter.execute(action, monitor);
                if (status.getSeverity() == 2) {
                    TargetPlugin.warningMessage(Messages.TargetAction_Warning, status.getMessage());
                    return Status.OK_STATUS;
                }
                if (status.getSeverity() == 4) {
                    TargetPlugin.errorMessage(MessageFormat.format(Messages.TargetAction_Error, TargetAction.this.getDescription()), status.getMessage());
                    return Status.OK_STATUS;
                }
                if (TargetAction.this.showResult && (result = status.getResult()) != null) {
                    TargetAction.this.infoMessage(TargetAction.this.getText(), result);
                }
                return status;
            }
        };
        job.setTarget(this.fSelectedTarget);
        job.setPriority(10);
        job.setUser(this.showProgress);
        job.schedule();
    }

    protected void infoMessage(final String title, final String message) {
        final Display display = TargetPlugin.getStandardDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = display.getActiveShell();
                if (shell == null) {
                    shell = new Shell(display);
                }
                Dialog dialog = TargetAction.this.createResultDialog(title, message, shell);
                dialog.open();
            }
        });
    }

    public String getCommand() {
        return this.fCommand;
    }

    public void setCommand(String command) {
        this.fCommand = command;
    }

    @Override
    public void setTarget(ITarget selection) {
        this.fSelectedTarget = selection;
    }

    public ITarget getTarget() {
        return this.fSelectedTarget;
    }

    @Override
    public boolean needsConnection() {
        return this.needsConnection;
    }

    public void needsConnection(boolean b) {
        this.needsConnection = b;
    }

    public void setShowResult(boolean showResult) {
        this.showResult = showResult;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public void setSubmenu(boolean submenu) {
        this.submenu = submenu;
    }

    @Override
    public boolean isDynamic() {
        return this.submenu;
    }

    @Override
    public IContributionItem getContents() {
        return null;
    }

    public Object[] getOptions() {
        return this.fOptions;
    }

    public void setOptions(Object[] options) {
        this.fOptions = options;
    }

    @Override
    public String getInterfaceId() {
        return this.fInterfaceId;
    }

    @Override
    public void setInterfaceId(String id) {
        this.fInterfaceId = id;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setAppliesTo(ITargetAction.TargetComponent appliesTo) {
        this.appliesTo = appliesTo;
    }

    @Override
    public ITargetAction.TargetComponent getAppliesTo() {
        return this.appliesTo;
    }

    @Override
    public String getHelpContextId() {
        return this.helpContextId;
    }

    public void setHelpContextId(String helpContextId) {
        this.helpContextId = helpContextId;
    }

    protected Dialog createResultDialog(String title, String message, Shell shell) {
        return new MonospacedResultDialog(shell, title, message, this.helpContextId);
    }

    private class MonospacedResultDialog
    extends ResultDialog {
        private MonospacedResultDialog(Shell parentShell, String dialogTitle, String dialogMessage, String helpContextId) {
            super(parentShell, dialogTitle, dialogMessage, helpContextId);
        }

        protected Control createDialogArea(Composite parent) {
            Label messageLabel = null;
            if (this.getMessage() != null) {
                messageLabel = new Label(parent, 0);
                messageLabel.setFont(fr.get("org.eclipse.jface.textfont"));
                messageLabel.setText(this.getMessage());
                GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(-1, -1).applyTo((Control)messageLabel);
            }
            return messageLabel;
        }
    }
}

