/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.ui;

import com.atmel.avr32.target.FuseRegisterSettings;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.TargetJob;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.ui.TargetActionDialog;
import com.atmel.avr32.target.ui.TargetDialogAction;
import com.atmel.avr32.target.ui.composites.ReadFusesDialogComposite;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ReadFusesAction
extends TargetDialogAction {
    @Override
    public void run() {
        TargetActionDialog rd;
        final ITargetInterface adapter = TargetPlugin.getDefault().getTargetInterface(this);
        if (adapter == null) {
            return;
        }
        adapter.setTarget(this.fSelectedTarget);
        IStatus ok = TargetPlugin.getTargetManager().validateOperation(this.getTarget(), 1);
        if (!ok.isOK()) {
            TargetPlugin.operationStatusMessage(ok);
            return;
        }
        Shell shell = TargetPlugin.getStandardDisplay().getActiveShell();
        if (shell == null) {
            shell = new Shell(new Display());
        }
        if ((rd = new TargetActionDialog(this, shell)).open() == 1) {
            return;
        }
        String filepath = ((ReadFusesDialogComposite)this.getComposite()).getFileName();
        final IPath path = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filepath)).getFullPath();
        TargetJob job = new TargetJob(this.getDescription()){

            public IStatus run(IProgressMonitor monitor) {
                String mcu = this.getTarget().getCpu();
                FuseRegisterSettings fs = new FuseRegisterSettings(mcu);
                IStatus status = adapter.readFuseSettings(fs, monitor);
                if (!status.isOK()) {
                    return status;
                }
                try {
                    fs.save(path);
                    this.open(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return status;
            }

            private void open(final IPath path2) throws PartInitException {
                Runnable update = new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page;
                        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                        if (windows != null && (page = windows[0].getActivePage()) != null) {
                            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path2);
                            FileEditorInput input = new FileEditorInput(file);
                            try {
                                page.openEditor((IEditorInput)input, "com.atmel.avr32.target.FuseEditor");
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                };
                Display.getDefault().asyncExec(update);
            }
        };
        job.setTarget(this.fSelectedTarget);
        job.setPriority(10);
        job.setUser(this.showProgress);
        job.schedule();
    }
}

