/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.tool.ui;

import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.ToolRegistry;
import com.atmel.avr32.target.part.model.DeviceSeries;
import com.atmel.avr32.target.tool.IPartSelectionProvider;
import com.atmel.avr32.target.tool.model.Tool;
import com.atmel.avr32.target.tool.ui.Messages;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionDialog;

public class DefaultPartSelectionProvider
implements IPartSelectionProvider {
    private static final String EMPTY_STRING = "";
    private static DefaultPartSelectionProvider instance;

    @Override
    public String getPart(ITarget target) {
        TreeDialog dlg = new TreeDialog(Display.getCurrent().getActiveShell());
        ContentProvider cp = new ContentProvider();
        dlg.setContentProvider(cp);
        dlg.setLabelProvider((ILabelProvider)new DeviceSelectionLabelProvider());
        dlg.setTitle(Messages.DefaultPartSelectionProvider_Title);
        if (target != null) {
            dlg.setInput(ToolRegistry.getTool(target.getAdapterName()));
            dlg.setMessage(Messages.DefaultPartSelectionProvider_Description);
        } else {
            dlg.setInput(PartRegistry.getDeviceSeries());
        }
        dlg.open();
        Object[] result = dlg.getResult();
        if (result != null) {
            return (String)result[0];
        }
        return EMPTY_STRING;
    }

    public static DefaultPartSelectionProvider getDefault() {
        if (instance == null) {
            instance = new DefaultPartSelectionProvider();
        }
        return instance;
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private Object input;

        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.input instanceof Tool) {
                return ((Tool)this.input).getSupportedDeviceSeries();
            }
            if (this.input instanceof DeviceSeries[]) {
                return (DeviceSeries[])this.input;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = newInput;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof DeviceSeries) {
                return ((DeviceSeries)parentElement).getDeviceIdentifiers();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof DeviceSeries;
        }
    }

    private class DeviceSelectionLabelProvider
    extends LabelProvider {
        private DeviceSelectionLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof DeviceSeries) {
                return ((DeviceSeries)element).getName();
            }
            return super.getText(element);
        }
    }

    private class TreeDialog
    extends SelectionDialog {
        private ITreeContentProvider fContentProvider;
        private ILabelProvider fLabelProvider;
        private Object fInput;
        private TreeViewer fTreeViewer;
        private boolean fAddCancelButton;
        private int widthInChars;
        private int heightInChars;

        public TreeDialog(Shell parent) {
            super(parent);
            this.fAddCancelButton = true;
            this.widthInChars = 55;
            this.heightInChars = 15;
        }

        public void setInput(Object input) {
            this.fInput = input;
        }

        public void setContentProvider(ITreeContentProvider sp) {
            this.fContentProvider = sp;
        }

        public void setLabelProvider(ILabelProvider lp) {
            this.fLabelProvider = lp;
        }

        public void setAddCancelButton(boolean addCancelButton) {
            this.fAddCancelButton = addCancelButton;
        }

        public TreeViewer getTableViewer() {
            return this.fTreeViewer;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            if (!this.fAddCancelButton) {
                this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            } else {
                super.createButtonsForButtonBar(parent);
            }
        }

        protected Control createDialogArea(Composite container) {
            Composite parent = (Composite)super.createDialogArea(container);
            this.createMessageArea(parent);
            this.fTreeViewer = new TreeViewer(parent, this.getTreeStyle());
            this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            this.fTreeViewer.setInput(this.fInput);
            this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (TreeDialog.this.fAddCancelButton) {
                        TreeDialog.this.okPressed();
                    }
                }
            });
            List initialSelection = this.getInitialElementSelections();
            if (initialSelection != null) {
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection(initialSelection));
            }
            GridData gd = new GridData(1808);
            gd.heightHint = this.convertHeightInCharsToPixels(this.heightInChars);
            gd.widthHint = this.convertWidthInCharsToPixels(this.widthInChars);
            Tree table = this.fTreeViewer.getTree();
            table.setLayoutData((Object)gd);
            table.setFont(container.getFont());
            return parent;
        }

        protected int getTreeStyle() {
            return 2820;
        }

        protected void okPressed() {
            IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
            this.setResult(selection.toList());
            super.okPressed();
        }
    }
}

