/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.tool.model;

import com.atmel.avr32.target.DeviceSeriesCollator;
import com.atmel.avr32.target.ITargetAlgorithmAdapter;
import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.part.model.DeviceSeries;
import com.atmel.avr32.target.tool.DefaultSupportedPartsProvider;
import com.atmel.avr32.target.tool.DefaultTargetConfigurationValidator;
import com.atmel.avr32.target.tool.IPartSelectionProvider;
import com.atmel.avr32.target.tool.ISupportedPartsProvider;
import com.atmel.avr32.target.tool.ITargetConfigurationValidator;
import com.atmel.avr32.target.tool.model.AbstractToolElement;
import com.atmel.avr32.target.tool.model.Capability;
import com.atmel.avr32.target.tool.model.Clock;
import com.atmel.avr32.target.tool.model.Interface;
import com.atmel.avr32.target.tool.model.Memory;
import com.atmel.avr32.target.tool.model.Voltage;
import com.atmel.avr32.target.tool.ui.DefaultPartSelectionProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Tool
extends AbstractToolElement
implements Comparable<Tool> {
    private static final String ATTR_SUPPORTED_PARTS_PROVIDER = "supportedPartsProvider";
    private static final String ATTR_PART_SELECTION_PROVIDER = "partSelectionProvider";
    private static final String ATTR_CONFIGURATION_VALIDATOR = "configurationValidator";
    private static final String ATTR_ICON = "icon";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_CLOCK = "clock";
    private static final String ATTR_VOLTAGE = "voltage";
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String ADAPTER = "adapter";
    private IConfigurationElement configurationElement;
    private String name;
    private String fId;
    private int type;
    private ArrayList<Memory> memory = new ArrayList();
    private ArrayList<Interface> interfaces = new ArrayList();
    private ArrayList<Voltage> voltages = new ArrayList();
    private ArrayList<Clock> clocks = new ArrayList();
    private ArrayList<Capability> capabilities = new ArrayList();
    IPartSelectionProvider fPartSelectionProvider = null;
    ISupportedPartsProvider fSupportedPartsProvider = null;
    ITargetConfigurationValidator fTargetConfigurationValidator = null;

    public Tool(IConfigurationElement element) {
        this.configurationElement = element;
        this.name = this.configurationElement.getAttribute(ATTR_NAME);
        this.fId = this.configurationElement.getAttribute(ID);
    }

    public ITargetAlgorithmAdapter getAlgorithm(String id) {
        try {
            IConfigurationElement[] a = this.configurationElement.getChildren(ADAPTER);
            if (a.length > 0) {
                IConfigurationElement[] iConfigurationElementArray = a[0].getChildren();
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    if ((element.getName().equals(ATTR_VOLTAGE) || element.getName().equals(ATTR_CLOCK)) && element.getAttribute(ID).equals(id)) {
                        return (ITargetAlgorithmAdapter)element.createExecutableExtension(CLASS);
                    }
                    ++n2;
                }
            }
            throw new IllegalArgumentException(MessageFormat.format("No algorithm with id {0} exists for tool {1}", id, this.fId));
        }
        catch (CoreException e) {
            e.printStackTrace();
            TargetPlugin.errorMessage("Instantiation error", MessageFormat.format("No could not instantiate algorithm with id \"{0}\".\n{1}", id, e.getMessage()));
            return null;
        }
    }

    public ImageDescriptor getIcon() {
        String pluginID = this.configurationElement.getContributor().getName();
        String icon = this.configurationElement.getAttribute(ATTR_ICON);
        if (icon == null) {
            return null;
        }
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginID, (String)icon);
    }

    public IPartSelectionProvider getPartSelectionProvider() throws CoreException {
        Object o;
        if (this.fPartSelectionProvider != null) {
            return this.fPartSelectionProvider;
        }
        String a = this.configurationElement.getAttribute(ATTR_PART_SELECTION_PROVIDER);
        if (a != null && (o = this.configurationElement.createExecutableExtension(ATTR_PART_SELECTION_PROVIDER)) instanceof IPartSelectionProvider) {
            this.fPartSelectionProvider = (IPartSelectionProvider)o;
        }
        if (this.fPartSelectionProvider == null) {
            this.fPartSelectionProvider = DefaultPartSelectionProvider.getDefault();
        }
        return this.fPartSelectionProvider;
    }

    public ISupportedPartsProvider getSupportedPartsProvider() throws CoreException {
        Object o;
        if (this.fSupportedPartsProvider != null) {
            return this.fSupportedPartsProvider;
        }
        String a = this.configurationElement.getAttribute(ATTR_SUPPORTED_PARTS_PROVIDER);
        if (a != null && (o = this.configurationElement.createExecutableExtension(ATTR_SUPPORTED_PARTS_PROVIDER)) instanceof ISupportedPartsProvider) {
            this.fSupportedPartsProvider = (ISupportedPartsProvider)o;
        }
        if (this.fSupportedPartsProvider == null) {
            this.fSupportedPartsProvider = new DefaultSupportedPartsProvider(this.configurationElement);
        }
        return this.fSupportedPartsProvider;
    }

    public ITargetConfigurationValidator getTargetConfigurationValidator() throws CoreException {
        Object o;
        if (this.fTargetConfigurationValidator != null) {
            return this.fTargetConfigurationValidator;
        }
        String a = this.configurationElement.getAttribute(ATTR_CONFIGURATION_VALIDATOR);
        if (a != null && (o = this.configurationElement.createExecutableExtension(ATTR_CONFIGURATION_VALIDATOR)) instanceof ITargetConfigurationValidator) {
            this.fTargetConfigurationValidator = (ITargetConfigurationValidator)o;
        }
        if (this.fTargetConfigurationValidator == null) {
            this.fTargetConfigurationValidator = DefaultTargetConfigurationValidator.getDefault();
        }
        return this.fTargetConfigurationValidator;
    }

    public String[] getSupportedParts() {
        try {
            String[] parts;
            ArrayList<String> templist = new ArrayList<String>();
            List<String> partsNames = PartRegistry.getPartNames();
            String[] stringArray = parts = this.getSupportedPartsProvider().getSupportedParts();
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (partsNames.contains(string)) {
                    templist.add(string);
                }
                ++n2;
            }
            return templist.toArray(new String[templist.size()]);
        }
        catch (CoreException coreException) {
            return new String[0];
        }
    }

    public DeviceSeries[] getSupportedDeviceSeries() {
        HashMap<String, DeviceSeries> supported = new HashMap<String, DeviceSeries>();
        DeviceSeries[] deviceSeriesArray = PartRegistry.getDeviceSeries();
        int n = deviceSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceSeries family = deviceSeriesArray[n2];
            String[] stringArray = family.getDeviceIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String t = stringArray[n4];
                String[] stringArray2 = this.getSupportedParts();
                int n5 = stringArray2.length;
                int n6 = 0;
                while (n6 < n5) {
                    String p = stringArray2[n6];
                    if (t.equals(p)) {
                        if (supported.containsKey(family.getId())) {
                            ((DeviceSeries)supported.get(family.getId())).addDeviceId(t);
                        } else {
                            DeviceSeries s = new DeviceSeries(family.getId(), family.getName());
                            s.addDeviceId(t);
                            supported.put(s.getId(), s);
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        ArrayList deviceSeries = new ArrayList(supported.values());
        Collections.sort(deviceSeries, new DeviceSeriesCollator());
        return deviceSeries.toArray(new DeviceSeries[deviceSeries.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSupportingDevice(String id) {
        try {
            String[] parts;
            String[] stringArray = parts = this.getSupportedPartsProvider().getSupportedParts();
            int n = parts.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String string = stringArray[n2];
                if (string.equals(id)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.fId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void addMemory(Memory memory) {
        this.memory.add(memory);
    }

    public void addInterface(Interface name) {
        this.interfaces.add(name);
    }

    public void addCapability(Capability capability) {
        this.capabilities.add(capability);
    }

    public void addVoltage(Voltage voltage) {
        this.voltages.add(voltage);
    }

    public void addClock(Clock clock) {
        this.clocks.add(clock);
    }

    public ArrayList<Memory> getMemory() {
        return this.memory;
    }

    public ArrayList<Interface> getInterfaces() {
        return this.interfaces;
    }

    public Voltage[] getVoltages() {
        return this.voltages.toArray(new Voltage[this.voltages.size()]);
    }

    public ArrayList<Capability> getCapabilities() {
        return this.capabilities;
    }

    public Clock[] getClocks() {
        return this.clocks.toArray(new Clock[this.clocks.size()]);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Tool o) {
        return this.getName().compareTo(o.getName());
    }
}

