/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.tool.model;

import com.atmel.avr32.target.tool.model.AbstractToolElement;
import com.atmel.avr32.target.tool.model.IMemoryBlock;
import com.atmel.avr32.target.tool.model.Messages;
import java.text.MessageFormat;
import java.util.HashMap;

public class Memory
extends AbstractToolElement
implements IMemoryBlock {
    String name;
    String address;
    String size;
    String type;
    int id;

    public Memory() {
    }

    public Memory(int id, String name, String address, String size, String type) {
        this.id = id;
        this.name = name;
        this.address = address;
        this.size = size;
        this.type = type;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @Override
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String toString() {
        return String.valueOf(this.address) + "," + this.size;
    }

    @Override
    public String toFormattedString() {
        return MessageFormat.format(Messages.Memory_Formatted, this.size, this.type.toUpperCase(), this.address, this.name);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public HashMap<String, String> getAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", new Integer(this.id).toString());
        map.put("address", this.address);
        map.put("size", this.size);
        return map;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

