/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.tool;

import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.tool.ISupportedPartsProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class DefaultSupportedPartsProvider
implements ISupportedPartsProvider {
    private static final String COMMENT_PREFIX = "#";
    private static final String PARTS = "parts";
    private static final String SUPPORTED_PARTS = "supportedParts";
    private String[] partList;
    private IConfigurationElement configurationElement;

    public DefaultSupportedPartsProvider(IConfigurationElement configurationElement) {
        this.configurationElement = configurationElement;
    }

    @Override
    public String[] getSupportedParts() {
        if (this.partList != null) {
            return this.partList;
        }
        ArrayList<String> templist = new ArrayList<String>();
        String parts = this.configurationElement.getAttribute(SUPPORTED_PARTS);
        if (parts == null) {
            Path path = new Path(this.configurationElement.getAttribute(PARTS));
            this.readPartlist(templist, path);
        } else {
            String[] regexp;
            List<String> partsNames = PartRegistry.getPartNames();
            String[] stringArray = regexp = parts.split(",");
            int n = regexp.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                Pattern pattern = Pattern.compile(string);
                for (String name : partsNames) {
                    Matcher matcher = pattern.matcher(name);
                    if (!matcher.find()) continue;
                    templist.add(name);
                }
                ++n2;
            }
        }
        Collections.sort(templist, Collator.getInstance());
        this.partList = templist.toArray(new String[templist.size()]);
        return this.partList;
    }

    private void readPartlist(ArrayList<String> templist, Path path) {
        try {
            String line;
            String pluginID = this.configurationElement.getContributor().getName();
            InputStream st = FileLocator.openStream((Bundle)Platform.getBundle((String)pluginID), (IPath)path, (boolean)false);
            BufferedReader br = new BufferedReader(new InputStreamReader(st));
            while ((line = br.readLine()) != null) {
                if (line.startsWith(COMMENT_PREFIX) || line.length() <= 0) continue;
                templist.add(line.trim());
            }
            br.close();
            st.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

