/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.model;

import com.atmel.avr32.target.debug.Watchable;
import com.atmel.avr32.target.part.model.Bitfield;
import com.atmel.avr32.target.part.model.BitfieldInstance;
import com.atmel.avr32.target.part.model.IModelInfo;
import com.atmel.avr32.target.part.model.IOModuleInstance;
import com.atmel.avr32.target.part.model.Register;
import com.atmel.avr32.target.part.model.RegisterGroupInstance;
import java.util.ArrayList;

public class RegisterInstance
extends Watchable {
    private IOModuleInstance instance;
    private Register register;
    private ArrayList<BitfieldInstance> bitfieldInstances = new ArrayList();
    private IModelInfo parent;
    private RegisterGroupInstance registerGroupInstance;

    public RegisterInstance(IOModuleInstance instance, Register register) {
        this.instance = instance;
        this.register = register;
        this.parent = instance;
        if (register.hasChildren()) {
            IModelInfo[] iModelInfoArray = register.getChildren();
            int n = iModelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModelInfo o = iModelInfoArray[n2];
                if (o instanceof Bitfield) {
                    this.bitfieldInstances.add(new BitfieldInstance(this, (Bitfield)o));
                }
                ++n2;
            }
        }
    }

    public RegisterInstance(IOModuleInstance instance, Register register, RegisterGroupInstance registerGroupInstance) {
        this(instance, register);
        this.registerGroupInstance = registerGroupInstance;
        this.parent = this.registerGroupInstance;
    }

    @Override
    public IModelInfo[] getChildren() {
        return this.bitfieldInstances.toArray(new BitfieldInstance[0]);
    }

    @Override
    public String getDescription() {
        return this.register.getDescription();
    }

    @Override
    public String getLocation() {
        String range = this.register.getMemoryRange();
        long baseAddress = this.instance.getMemoryRange(range).getAddress();
        if (this.registerGroupInstance != null) {
            baseAddress += this.registerGroupInstance.getAddressOffset();
        }
        return String.format("0x%08x", baseAddress + this.register.getAddressOffset());
    }

    @Override
    public String getName() {
        String suffix;
        String name = this.register.getName();
        if (this.registerGroupInstance != null && (suffix = this.registerGroupInstance.getStripSuffix()) != null) {
            return name.substring(0, name.length() - suffix.length());
        }
        return name;
    }

    @Override
    public boolean hasChildren() {
        return this.register.hasChildren();
    }

    @Override
    public long getAddress() {
        long address = this.instance.getMemoryRange(this.register.getMemoryRange()).getAddress() + this.register.getAddress();
        if (this.registerGroupInstance != null) {
            address += this.registerGroupInstance.getAddressOffset();
        }
        return address;
    }

    public Register getRegister() {
        return this.register;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RegisterInstance@");
        sb.append(Long.toHexString(this.getAddress()).toString());
        sb.append(" (");
        sb.append(this.getName());
        sb.append(") = ");
        sb.append(this.getValue());
        sb.append(" (");
        sb.append(this.getFormattedValue());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public IModelInfo getParent() {
        return this.parent;
    }

    @Override
    public boolean isSystemRegister() {
        return false;
    }
}

