/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.model;

import com.atmel.avr32.target.part.model.AbstractModelInfo;
import com.atmel.avr32.target.part.model.IModelInfo;
import com.atmel.avr32.target.part.model.IOModuleInstance;
import com.atmel.avr32.target.part.model.Register;
import com.atmel.avr32.target.part.model.RegisterGroup;
import com.atmel.avr32.target.part.model.RegisterInstance;
import java.util.ArrayList;

public class RegisterGroupInstance
extends AbstractModelInfo {
    private static final String EMPTY = "";
    private IOModuleInstance parent;
    private RegisterGroup registerGroup;
    private final int number;
    private ArrayList<RegisterInstance> registerInstances;

    public RegisterGroupInstance(IOModuleInstance moduleInstance, RegisterGroup registerGroup, int number) {
        this.parent = moduleInstance;
        this.registerGroup = registerGroup;
        this.number = number;
        this.registerInstances = new ArrayList();
        for (Register register : registerGroup.getRegisters()) {
            this.registerInstances.add(new RegisterInstance(moduleInstance, register, this));
        }
    }

    @Override
    public long getAddress() {
        return 0L;
    }

    @Override
    public IModelInfo[] getChildren() {
        return this.registerInstances.toArray(new IModelInfo[this.registerInstances.size()]);
    }

    @Override
    public String getDescription() {
        return EMPTY;
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public String getName() {
        return String.valueOf(this.registerGroup.getName()) + '[' + String.valueOf(this.number) + ']';
    }

    @Override
    public IModelInfo getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RegisterGroupInstance ");
        sb.append(this.parent.getName());
        sb.append("->");
        sb.append(this.getName());
        sb.append(" with ");
        sb.append(Integer.toString(this.registerInstances.size()));
        sb.append(" children.");
        return sb.toString();
    }

    public long getAddressOffset() {
        return this.registerGroup.getSize() * this.number;
    }

    public String getStripSuffix() {
        return this.registerGroup.getStripSuffix();
    }
}

