/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.model;

import com.atmel.avr32.target.part.model.IOModule;
import com.atmel.avr32.target.part.model.IOModuleInstance;
import com.atmel.avr32.target.part.model.Parameter;
import com.atmel.avr32.target.part.model.Register;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;

public class RegisterGroup {
    private IOModule ioModule;
    private String name;
    private String start;
    private int size;
    private int count;
    private String stripSuffix;
    private ArrayList<Register> registers;
    private String countParameter;
    private Register cachedStartRegister;

    public RegisterGroup(IOModule ioModule) {
        this.ioModule = ioModule;
        ioModule.addRegisterGroup(this);
        this.registers = new ArrayList();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setStripSuffix(String suffix) {
        this.stripSuffix = suffix;
    }

    public ArrayList<Register> getRegisters() {
        return this.registers;
    }

    public RegisterRelation shouldContainRegister(Register register) {
        return this.isRegisterInGroupRange(register);
    }

    private RegisterRelation isRegisterInGroupRange(Register register) {
        long startRegisterOffset;
        long addressOffset = register.getAddressOffset();
        if (addressOffset >= (startRegisterOffset = this.getStartRegister().getAddressOffset())) {
            if (addressOffset < startRegisterOffset + (long)this.size) {
                return RegisterRelation.InFirstGroupInstance;
            }
            if (addressOffset < startRegisterOffset + (long)(this.size * this.count)) {
                return RegisterRelation.InOtherGroupInstance;
            }
        }
        return RegisterRelation.NotInGroup;
    }

    private Register getStartRegister() {
        if (this.cachedStartRegister != null) {
            return this.cachedStartRegister;
        }
        for (Register register : this.ioModule.getRegisters()) {
            if (!register.getName().equals(this.start)) continue;
            this.cachedStartRegister = register;
            break;
        }
        Assert.isNotNull((Object)this.cachedStartRegister, (String)"Invalid part XML file, start element for register_group not found.");
        return this.cachedStartRegister;
    }

    public boolean containsRegister(Register register) {
        for (Register r : this.registers) {
            if (!register.getName().equals(r.getName())) continue;
            return true;
        }
        return false;
    }

    public int getCount(IOModuleInstance instance) {
        Parameter parameter;
        int actualCount = this.count;
        if (this.countParameter != null && (parameter = instance.getParameter(this.countParameter)) != null) {
            String value = parameter.getValue();
            try {
                actualCount = Integer.decode(value.trim());
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("I/O module instance defines parameter " + this.countParameter + " to unparseable value " + value);
            }
        }
        return actualCount;
    }

    public String getName() {
        return this.name;
    }

    public void reparentRegisters() {
        this.ioModule.reparentRegistersToGroup(this);
    }

    public void addRegister(Register register) {
        this.registers.add(register);
    }

    public String getStripSuffix() {
        return this.stripSuffix;
    }

    public void setCountParameter(String param) {
        this.countParameter = param;
    }

    static enum RegisterRelation {
        InFirstGroupInstance,
        InOtherGroupInstance,
        NotInGroup;

    }
}

