/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.model;

import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.debug.Watchable;
import com.atmel.avr32.target.part.model.Bitfield;
import com.atmel.avr32.target.part.model.IModelInfo;
import com.atmel.avr32.target.part.model.RegisterMode;
import java.util.ArrayList;

public class Register
extends Watchable {
    private String name;
    private long addressOffset;
    private long resetValue;
    private String text;
    private boolean display;
    private boolean fuse;
    private String memoryRange = "base";
    private ArrayList<RegisterMode> registerModes;
    private IModelInfo parent;

    public Register(IModelInfo parent) {
        this.parent = parent;
        this.registerModes = new ArrayList();
    }

    public long getAddressOffset() {
        return this.addressOffset;
    }

    public void setAddressOffset(long addressOffset) {
        this.addressOffset = addressOffset;
    }

    public boolean isDisplay() {
        return this.display;
    }

    public void setDisplay(boolean display) {
        this.display = display;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<RegisterMode> getRegisterModes() {
        return this.registerModes;
    }

    public void addRegisterMode(RegisterMode registerMode) {
        this.registerModes.add(registerMode);
    }

    public long getResetValue() {
        return this.resetValue;
    }

    public void setResetValue(long resetValue) {
        this.resetValue = resetValue;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getMemoryRange() {
        return this.memoryRange;
    }

    public void setMemoryRange(String memoryRange) {
        this.memoryRange = memoryRange;
    }

    @Override
    public IModelInfo[] getChildren() {
        if (!this.hasChildren()) {
            return null;
        }
        if (this.registerModes.size() > 1) {
            TargetPlugin.debug("Register " + this.name + " has several modes, ignoring!");
        }
        return this.registerModes.get(0).getBitfields().toArray(new Bitfield[0]);
    }

    @Override
    public String getDescription() {
        return this.text;
    }

    @Override
    public String getLocation() {
        return String.format("0x%08x", this.getAddress());
    }

    @Override
    public boolean hasChildren() {
        return this.registerModes.size() > 0;
    }

    @Override
    public long getAddress() {
        return this.addressOffset;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Register@");
        sb.append(Long.toHexString(this.getAddress()).toString());
        sb.append(" (");
        sb.append(this.getName());
        sb.append(") = ");
        sb.append(this.getValue());
        sb.append(" (");
        sb.append(this.getFormattedValue());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public IModelInfo getParent() {
        return this.parent;
    }

    public boolean isFuse() {
        return this.fuse;
    }

    public void setFuse(boolean fuse) {
        this.fuse = fuse;
    }

    @Override
    public boolean isSystemRegister() {
        return true;
    }
}

