/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.model;

import com.atmel.avr32.target.part.model.AbstractModelInfo;
import com.atmel.avr32.target.part.model.Core;
import com.atmel.avr32.target.part.model.DebugSystem;
import com.atmel.avr32.target.part.model.Fuse;
import com.atmel.avr32.target.part.model.IBitfield;
import com.atmel.avr32.target.part.model.IModelInfo;
import com.atmel.avr32.target.part.model.IOModule;
import com.atmel.avr32.target.part.model.IOModuleInstance;
import com.atmel.avr32.target.part.model.InterruptController;
import com.atmel.avr32.target.part.model.MemoryBlock;
import com.atmel.avr32.target.tool.model.Capability;
import java.util.ArrayList;

public class Part
implements IModelInfo {
    private static final String INTERNAL_FLASH_NAME = "FLASH";
    private String name;
    private Core core;
    private ArrayList<IOModule> ioModules = new ArrayList();
    private ArrayList<MemoryBlock> memories = new ArrayList();
    private ArrayList<Fuse> fuses = new ArrayList();
    private DebugSystem debugSystem = new DebugSystem();
    private IModelInfo[] children;
    private boolean clockable;
    private String resetVector;
    private String partFamily;
    private ArrayList<Capability> capabilities;
    private InterruptController interruptController;

    public String getPartFamily() {
        return this.partFamily;
    }

    public String getResetVector() {
        return this.resetVector;
    }

    public void setResetVector(String resetVector) {
        this.resetVector = resetVector;
    }

    public Part(String partFamily) {
        this.partFamily = partFamily;
        this.capabilities = new ArrayList();
    }

    public void addMemory(MemoryBlock memory) {
        this.memories.add(memory);
    }

    public ArrayList<MemoryBlock> getMemoryBlocks() {
        return this.memories;
    }

    public void addFuse(Fuse fuse) {
        this.fuses.add(fuse);
    }

    public void clearFuses() {
        this.fuses.clear();
    }

    public ArrayList<Fuse> getFuses() {
        return this.fuses;
    }

    public ArrayList<MemoryBlock> getInternFlash() {
        ArrayList<MemoryBlock> flash = new ArrayList<MemoryBlock>();
        for (MemoryBlock memory : this.memories) {
            if (memory.getMemoryType() == null || !memory.getMemoryType().equals(INTERNAL_FLASH_NAME)) continue;
            flash.add(memory);
        }
        return flash;
    }

    public void addIOModule(IOModule m) {
        this.ioModules.add(m);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Core getCore() {
        return this.core;
    }

    public void setCore(Core core) {
        this.core = core;
    }

    @Override
    public IModelInfo[] getChildren() {
        if (this.children == null) {
            ArrayList<AbstractModelInfo> cl = new ArrayList<AbstractModelInfo>();
            cl.add(this.core);
            if (this.interruptController != null) {
                cl.add(this.interruptController);
            }
            for (IOModule module : this.ioModules) {
                for (IOModuleInstance i : module.getInstances()) {
                    i.setParent(this);
                    cl.add(i);
                }
            }
            this.children = cl.toArray(new IModelInfo[0]);
        }
        return this.children;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    public IModelInfo findNode(IModelInfo element, long address) {
        if (element.getAddress() == address && !(element instanceof IOModule) && !(element instanceof IOModuleInstance)) {
            return element;
        }
        if (element.hasChildren()) {
            IModelInfo current = null;
            IModelInfo[] iModelInfoArray = element.getChildren();
            int n = iModelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModelInfo object = iModelInfoArray[n2];
                current = this.findNode(object, address);
                if (current != null) {
                    return current;
                }
                ++n2;
            }
        }
        return null;
    }

    public IModelInfo findNode(IModelInfo element, long address, int bit) {
        if (element.getAddress() == address && element instanceof IBitfield && ((IBitfield)((Object)element)).getNumber() == bit) {
            return element;
        }
        if (element.hasChildren()) {
            IModelInfo current = null;
            IModelInfo[] iModelInfoArray = element.getChildren();
            int n = iModelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModelInfo object = iModelInfoArray[n2];
                current = this.findNode(object, address, bit);
                if (current != null) {
                    return current;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public long getAddress() {
        return 0L;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        return buffer.toString();
    }

    @Override
    public IModelInfo getParent() {
        return null;
    }

    @Override
    public String getPath() {
        return null;
    }

    public boolean isClockable() {
        return this.clockable;
    }

    public void setClockable(boolean clockable) {
        this.clockable = clockable;
    }

    public DebugSystem getDebugSystem() {
        return this.debugSystem;
    }

    public ArrayList<Capability> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(ArrayList<Capability> capabilities) {
        this.capabilities = capabilities;
    }

    public void setInterruptController(InterruptController intc) {
        this.interruptController = intc;
    }

    public InterruptController getInterruptController() {
        return this.interruptController;
    }
}

