/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.model;

import com.atmel.avr32.target.tool.model.IMemoryBlock;
import java.text.MessageFormat;

public class MemoryBlock
implements IMemoryBlock {
    private static final String INTERNAL = "internal";
    private String name;
    private String memoryType;
    private String address;
    private String size;
    private static final String[] SI_UNITS = new String[]{"kB", "MB"};
    private static final long[] SI_VALUES = new long[]{1024L, 0x100000L};

    @Override
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        Long l = Long.decode(size);
        this.size = this.calculate(l);
    }

    @Override
    public String getType() {
        return INTERNAL;
    }

    public String getMemoryType() {
        return this.memoryType;
    }

    public void setMemoryType(String type) {
        this.memoryType = type;
    }

    @Override
    public String toFormattedString() {
        return MessageFormat.format("{0} of internal flash located at {1}", this.getSize(), this.getAddress());
    }

    private String calculate(long value) {
        String rv = String.valueOf(value);
        int a = 0;
        while (a < SI_VALUES.length) {
            if (value > SI_VALUES[a] * 10L) {
                long v = value / SI_VALUES[a];
                rv = String.valueOf(String.valueOf(v)) + SI_UNITS[a];
            }
            ++a;
        }
        return rv;
    }
}

