/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.model;

import com.atmel.avr32.target.part.model.AbstractModelInfo;
import com.atmel.avr32.target.part.model.IModelInfo;
import com.atmel.avr32.target.part.model.InterruptRegister;
import com.atmel.avr32.target.part.model.InterruptRegisterGroup;

public class InterruptController
extends AbstractModelInfo {
    InterruptRegisterGroup causeRegisters;
    InterruptRegisterGroup groupRegisters;
    private long address;
    private IModelInfo parent;

    public InterruptController(IModelInfo parent) {
        this.parent = parent;
        this.causeRegisters = new InterruptRegisterGroup(this, "Cause registers", "Interrupt Cause Registers");
        this.groupRegisters = new InterruptRegisterGroup(this, "Groups", "Interrupt Groups");
    }

    @Override
    public long getAddress() {
        return this.address;
    }

    @Override
    public IModelInfo[] getChildren() {
        return new IModelInfo[]{this.causeRegisters, this.groupRegisters};
    }

    @Override
    public String getDescription() {
        return "Interrupt Controller";
    }

    @Override
    public String getLocation() {
        return String.format("0x%08x", this.getAddress());
    }

    @Override
    public String getName() {
        return "INTC";
    }

    @Override
    public IModelInfo getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    public void addCauseRegister(InterruptRegister r) {
        this.causeRegisters.add(r);
    }

    public void addGroupRegister(InterruptRegister r) {
        this.groupRegisters.add(r);
    }

    public void setAddress(long address) {
        this.address = address;
    }
}

