/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.model;

import com.atmel.avr32.target.part.model.AbstractModelInfo;
import com.atmel.avr32.target.part.model.IModelInfo;
import com.atmel.avr32.target.part.model.IOModule;
import com.atmel.avr32.target.part.model.IOModuleInstanceMemoryRange;
import com.atmel.avr32.target.part.model.Parameter;
import com.atmel.avr32.target.part.model.Part;
import com.atmel.avr32.target.part.model.Register;
import com.atmel.avr32.target.part.model.RegisterGroup;
import com.atmel.avr32.target.part.model.RegisterGroupInstance;
import com.atmel.avr32.target.part.model.RegisterInstance;
import java.util.ArrayList;

public class IOModuleInstance
extends AbstractModelInfo
implements IModelInfo {
    private Part parent;
    private IOModule module;
    private String name;
    private ArrayList<IOModuleInstanceMemoryRange> memoryRanges;
    private ArrayList<RegisterInstance> registerInstances;
    private ArrayList<RegisterGroupInstance> registerGroupInstances;
    private ArrayList<Parameter> parameters = new ArrayList();

    public IOModuleInstance(IOModule module) {
        this.module = module;
        this.memoryRanges = new ArrayList();
        module.addInstance(this);
        this.registerInstances = new ArrayList();
        this.registerGroupInstances = new ArrayList();
    }

    @Override
    public IModelInfo[] getChildren() {
        int numberOfRegisters = this.registerInstances.size();
        IModelInfo[] children = new IModelInfo[numberOfRegisters + this.registerGroupInstances.size()];
        this.registerInstances.toArray(children);
        int i = 0;
        while (i < this.registerGroupInstances.size()) {
            children[numberOfRegisters + i] = this.registerGroupInstances.get(i);
            ++i;
        }
        return children;
    }

    @Override
    public String getDescription() {
        return this.module.getDescription();
    }

    @Override
    public String getLocation() {
        if (this.memoryRanges.size() == 0) {
            return "";
        }
        return String.format("0x%08x", this.memoryRanges.get(0).getAddress());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean hasChildren() {
        return this.module.hasChildren();
    }

    public ArrayList<IOModuleInstanceMemoryRange> getMemoryRanges() {
        return this.memoryRanges;
    }

    public void addMemoryRange(IOModuleInstanceMemoryRange memoryRange) {
        this.memoryRanges.add(memoryRange);
    }

    public IOModuleInstanceMemoryRange getMemoryRange(String name) {
        for (IOModuleInstanceMemoryRange r : this.memoryRanges) {
            if (!r.getName().equals(name)) continue;
            return r;
        }
        return null;
    }

    public void populateInstance() {
        for (RegisterGroup rg : this.module.getRegisterGroups()) {
            int count = rg.getCount(this);
            int i = 0;
            while (i < count) {
                this.registerGroupInstances.add(new RegisterGroupInstance(this, rg, i));
                ++i;
            }
        }
        for (Register r : this.module.getRegisters()) {
            this.registerInstances.add(new RegisterInstance(this, r));
        }
    }

    @Override
    public long getAddress() {
        if (this.memoryRanges.size() == 0) {
            return 0L;
        }
        return this.memoryRanges.get(0).getAddress();
    }

    @Override
    public Part getParent() {
        return this.parent;
    }

    public void setParent(Part parent) {
        this.parent = parent;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("I/O Module instance ");
        sb.append(this.name);
        sb.append(", memory ranges: ");
        sb.append(this.memoryRanges.toString());
        return sb.toString();
    }

    public void addParameter(Parameter parameter) {
        this.parameters.add(parameter);
    }

    public Parameter getParameter(String name) {
        for (Parameter param : this.parameters) {
            if (!name.equals(param.getName())) continue;
            return param;
        }
        return null;
    }
}

