/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.model;

import com.atmel.avr32.target.part.model.AbstractModelInfo;
import com.atmel.avr32.target.part.model.IModelInfo;
import com.atmel.avr32.target.part.model.IOModuleInstance;
import com.atmel.avr32.target.part.model.Register;
import com.atmel.avr32.target.part.model.RegisterGroup;
import java.util.ArrayList;

public class IOModule
extends AbstractModelInfo
implements IModelInfo {
    private String name;
    private String text;
    private ArrayList<Register> registers = new ArrayList();
    private ArrayList<IOModuleInstance> instances = new ArrayList();
    private ArrayList<RegisterGroup> registerGroups = new ArrayList();

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public ArrayList<Register> getRegisters() {
        return this.registers;
    }

    public void addRegister(Register r) {
        this.registers.add(r);
    }

    @Override
    public IModelInfo[] getChildren() {
        return this.registers.toArray(new Register[0]);
    }

    @Override
    public String getDescription() {
        return this.text;
    }

    @Override
    public String getLocation() {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return !this.registers.isEmpty() || !this.registerGroups.isEmpty();
    }

    public ArrayList<IOModuleInstance> getInstances() {
        return this.instances;
    }

    public void addInstance(IOModuleInstance i) {
        this.instances.add(i);
    }

    @Override
    public long getAddress() {
        return 0L;
    }

    @Override
    public IModelInfo getParent() {
        return null;
    }

    public void addRegisterGroup(RegisterGroup registerGroup) {
        this.registerGroups.add(registerGroup);
    }

    public ArrayList<RegisterGroup> getRegisterGroups() {
        return this.registerGroups;
    }

    public void reparentRegistersToGroup(RegisterGroup registerGroup) {
        int i = 0;
        while (i < this.registers.size()) {
            Register reg = this.registers.get(i);
            switch (registerGroup.shouldContainRegister(reg)) {
                case InFirstGroupInstance: {
                    registerGroup.addRegister(reg);
                }
                case InOtherGroupInstance: {
                    this.registers.remove(i);
                    break;
                }
                case NotInGroup: {
                    ++i;
                }
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("I/O Module ");
        sb.append(this.name);
        return sb.toString();
    }
}

