/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.model;

import com.atmel.avr32.target.debug.Watchable;
import com.atmel.avr32.target.part.model.Bitfield;
import com.atmel.avr32.target.part.model.IBitfield;
import com.atmel.avr32.target.part.model.IModelInfo;
import com.atmel.avr32.target.part.model.RegisterInstance;

public class BitfieldInstance
extends Watchable
implements IBitfield {
    private Bitfield bitfield;
    private RegisterInstance parent;

    public BitfieldInstance(RegisterInstance parent, Bitfield bitfield) {
        this.parent = parent;
        this.bitfield = bitfield;
    }

    @Override
    public String descriptiveValue(long value) {
        return this.bitfield.descriptiveValue(value);
    }

    @Override
    public long getAddress() {
        return this.parent.getAddress();
    }

    public Bitfield getBitfield() {
        return this.bitfield;
    }

    @Override
    public IModelInfo[] getChildren() {
        return null;
    }

    @Override
    protected int getDefaultFormat() {
        return this.bitfield.getDefaultFormat();
    }

    @Override
    public String getDescription() {
        return this.bitfield.getDescription();
    }

    @Override
    public String getLocation() {
        return this.bitfield.getLocation();
    }

    @Override
    public String getName() {
        return this.bitfield.getName();
    }

    @Override
    public int getNumber() {
        return this.bitfield.getNumber();
    }

    @Override
    public IModelInfo getParent() {
        return this.parent;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public void setValue(long value) {
        super.setValue(value >> this.bitfield.getNumber() & (long)((1 << this.bitfield.getSize()) - 1));
    }

    @Override
    public boolean testValue(long newValue) {
        return (newValue >> this.bitfield.getNumber() & (long)((1 << this.bitfield.getSize()) - 1)) != this.getValue();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Bitfield@");
        sb.append(Long.toHexString(this.getAddress()).toString());
        sb.append(" (");
        sb.append(this.getName());
        sb.append(") = ");
        sb.append(this.getValue());
        sb.append(" (");
        sb.append(this.getFormattedValue());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean isSystemRegister() {
        return false;
    }
}

