/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.model;

import com.atmel.avr32.target.debug.Watchable;
import com.atmel.avr32.target.part.model.BitfieldValue;
import com.atmel.avr32.target.part.model.IBitfield;
import com.atmel.avr32.target.part.model.IModelInfo;
import com.atmel.avr32.target.part.model.InterruptRegister;
import com.atmel.avr32.target.part.model.Register;
import java.util.ArrayList;

public class Bitfield
extends Watchable
implements IBitfield {
    private int number;
    private int size;
    private String name;
    private String text;
    private Register parent;
    private ArrayList<BitfieldValue> bitfieldValues;

    public Bitfield(Register parent) {
        this.parent = parent;
        this.setReadonly(this.parent.isReadonly());
        this.bitfieldValues = new ArrayList();
    }

    public ArrayList<BitfieldValue> getBitfieldValues() {
        return this.bitfieldValues;
    }

    public void addBitfieldValue(BitfieldValue bitfieldValue) {
        this.bitfieldValues.add(bitfieldValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public IModelInfo[] getChildren() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.text;
    }

    @Override
    public String getLocation() {
        if (this.getSize() == 1) {
            return "bit " + String.valueOf(this.getNumber());
        }
        return "bits [" + String.valueOf(this.getNumber() + this.getSize() - 1) + ".." + String.valueOf(this.getNumber()) + "]";
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public long getAddress() {
        return this.parent.getAddress();
    }

    @Override
    public void setValue(long value) {
        super.setValue(value >> this.getNumber() & (long)((1 << this.getSize()) - 1));
    }

    @Override
    public String descriptiveValue(long value) {
        if (this.hasBitfieldValues()) {
            for (BitfieldValue bfv : this.getBitfieldValues()) {
                if (value != (long)bfv.getValue()) continue;
                return bfv.getDescription();
            }
        }
        if (this.singleBitRegisterFieldWithMissingValues()) {
            return value == 0L ? "no" : "yes";
        }
        return super.descriptiveValue(value);
    }

    private boolean singleBitRegisterFieldWithMissingValues() {
        return this.hasBitfieldValues() && this.getSize() == 1;
    }

    @Override
    protected int getDefaultFormat() {
        if (this.hasBitfieldValues() || this.singleBitRegisterFieldWithMissingValues()) {
            return 3;
        }
        if (this.getSize() < 3) {
            return 0;
        }
        return super.getDefaultFormat();
    }

    private boolean hasBitfieldValues() {
        return !this.getBitfieldValues().isEmpty();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Bitfield@");
        sb.append(Long.toHexString(this.getAddress()).toString());
        sb.append(" (");
        sb.append(this.name);
        sb.append(") = ");
        sb.append(this.getValue());
        sb.append(" (");
        sb.append(this.getFormattedValue());
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean testValue(long newValue) {
        return (newValue >> this.getNumber() & (long)((1 << this.getSize()) - 1)) != this.getValue();
    }

    @Override
    public IModelInfo getParent() {
        return this.parent;
    }

    @Override
    public boolean isSystemRegister() {
        return !(this.parent instanceof InterruptRegister);
    }
}

