/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.internal;

import com.atmel.avr32.target.part.internal.XMLBitfieldHandler;
import com.atmel.avr32.target.part.model.Bitfield;
import com.atmel.avr32.target.part.model.RegisterMode;
import com.atmel.avr32.util.xml.IXMLNodeHandler;
import com.atmel.avr32.util.xml.XMLNodeHandler;
import org.xml.sax.SAXException;

public class XMLRegisterModeHandler
extends XMLNodeHandler {
    private int state;
    private RegisterMode registerMode;

    public XMLRegisterModeHandler(RegisterMode rm) {
        this.registerMode = rm;
        this.state = 0;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.state != 0) {
            this.addCharacters(new String(ch, start, length));
        }
    }

    public void endElement(String qName) throws SAXException {
        switch (this.state) {
            case 1: {
                this.registerMode.setName(this.takeCharacters());
                break;
            }
            case 2: {
                this.registerMode.setModeRegister(this.takeCharacters());
                break;
            }
            case 3: {
                this.registerMode.setModeBitfield(this.takeCharacters());
                break;
            }
            case 4: {
                this.registerMode.setModeValue(this.takeCharactersAsInteger());
                break;
            }
            case 5: {
                this.registerMode.setText(this.takeCharacters());
            }
        }
        this.state = 0;
    }

    public IXMLNodeHandler startElement(String qName) throws SAXException {
        if (qName == "name") {
            this.state = 1;
        } else if (qName == "mode_reg") {
            this.state = 2;
        } else if (qName == "mode_bitfield") {
            this.state = 3;
        } else if (qName == "mode_value") {
            this.state = 4;
        } else if (qName == "bitfield") {
            Bitfield bf = new Bitfield(this.registerMode.getParent());
            XMLBitfieldHandler bfh = new XMLBitfieldHandler(bf);
            this.registerMode.addBitfield(bf);
            return bfh;
        }
        return this;
    }

    private class State {
        public static final int NONE = 0;
        public static final int NAME = 1;
        public static final int MODE_REG = 2;
        public static final int MODE_BITFIELD = 3;
        public static final int MODE_VALUE = 4;
        public static final int TEXT = 5;

        private State() {
        }
    }
}

