/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.internal;

import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.part.internal.XMLRegisterModeHandler;
import com.atmel.avr32.target.part.model.Register;
import com.atmel.avr32.target.part.model.RegisterMode;
import com.atmel.avr32.util.xml.IXMLNodeHandler;
import com.atmel.avr32.util.xml.XMLNodeHandler;
import org.xml.sax.SAXException;

public class XMLRegisterHandler
extends XMLNodeHandler {
    private int state = 0;
    private Register register;

    public XMLRegisterHandler(Register r) {
        this.register = r;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.state != 0) {
            this.addCharacters(new String(ch, start, length));
        }
    }

    public IXMLNodeHandler startElement(String qName) throws SAXException {
        if (qName == "name") {
            this.state = 1;
        } else if (qName == "addr_offset") {
            this.state = 2;
        } else if (qName == "reset_value") {
            this.state = 3;
        } else if (qName == "access") {
            this.state = 4;
        } else if (qName == "text") {
            this.state = 5;
        } else if (qName == "display") {
            this.state = 6;
        } else if (qName == "memory_range") {
            this.state = 7;
        } else if (qName == "fuse") {
            this.state = 8;
        } else if (qName == "mode") {
            RegisterMode m = new RegisterMode(this.register);
            XMLRegisterModeHandler mh = new XMLRegisterModeHandler(m);
            this.register.addRegisterMode(m);
            return mh;
        }
        return this;
    }

    public void endElement(String qName) throws SAXException {
        switch (this.state) {
            case 1: {
                this.register.setName(this.takeCharacters());
                break;
            }
            case 2: {
                try {
                    this.register.setAddressOffset(this.takeCharactersAsLong());
                }
                catch (NumberFormatException e) {
                    TargetPlugin.debug(e);
                }
                break;
            }
            case 3: {
                this.register.setResetValue(this.takeCharactersAsLong());
                break;
            }
            case 4: {
                this.register.setReadonly(this.takeCharacters().indexOf("W") <= -1);
                break;
            }
            case 5: {
                this.register.setText(this.takeCharacters());
                break;
            }
            case 6: {
                this.register.setDisplay(this.takeCharacters().equals("Y"));
                break;
            }
            case 7: {
                this.register.setMemoryRange(this.takeCharacters());
                break;
            }
            case 8: {
                this.register.setFuse(this.takeCharacters().equals("Y"));
            }
        }
        this.state = 0;
    }

    private class State {
        public static final int NONE = 0;
        public static final int NAME = 1;
        public static final int ADDR_OFFSET = 2;
        public static final int RESET_VALUE = 3;
        public static final int ACCESS = 4;
        public static final int TEXT = 5;
        public static final int DISPLAY = 6;
        public static final int MEMORY_RANGE = 7;
        public static final int FUSE = 8;

        private State() {
        }
    }
}

