/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.internal;

import com.atmel.avr32.target.part.internal.XMLCoreHandler;
import com.atmel.avr32.target.part.internal.XMLIOModuleHandler;
import com.atmel.avr32.target.part.internal.XMLInterruptControllerHandler;
import com.atmel.avr32.target.part.internal.XMLMemoryBlockHandler;
import com.atmel.avr32.target.part.model.Core;
import com.atmel.avr32.target.part.model.IOModule;
import com.atmel.avr32.target.part.model.InterruptController;
import com.atmel.avr32.target.part.model.MemoryBlock;
import com.atmel.avr32.target.part.model.Part;
import com.atmel.avr32.util.xml.IXMLNodeHandler;
import com.atmel.avr32.util.xml.XMLNodeHandler;
import org.xml.sax.SAXException;

public class XMLPartDescriptionFileHandler
extends XMLNodeHandler {
    private static final String BLOCK = "block";
    private static final String IO_MODULE = "io_module";
    private static final String CORE = "core";
    private static final String INTC = "intc";
    private static final String PART_NAME = "part_name";
    private boolean isPartNameActive = false;
    private Part part;

    public XMLPartDescriptionFileHandler(Part p) {
        this.part = p;
    }

    public IXMLNodeHandler startElement(String qName) throws SAXException {
        if (qName.equals(PART_NAME)) {
            this.isPartNameActive = true;
        } else {
            if (qName.equals(CORE)) {
                Core c = new Core(this.part);
                this.part.setCore(c);
                return new XMLCoreHandler(c);
            }
            if (qName.equals(IO_MODULE)) {
                IOModule m = new IOModule();
                this.part.addIOModule(m);
                return new XMLIOModuleHandler(m);
            }
            if (qName.equals(BLOCK)) {
                MemoryBlock m = new MemoryBlock();
                this.part.addMemory(m);
                return new XMLMemoryBlockHandler(m);
            }
            if (qName.equals(INTC)) {
                InterruptController intc = new InterruptController(this.part);
                this.part.setInterruptController(intc);
                return new XMLInterruptControllerHandler(intc);
            }
        }
        return this;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isPartNameActive) {
            this.addCharacters(new String(ch, start, length));
        }
    }

    public void endElement(String qName) throws SAXException {
        if (this.isPartNameActive) {
            this.part.setName(this.takeCharacters());
        }
        this.isPartNameActive = false;
    }
}

