/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.internal;

import com.atmel.avr32.target.part.model.MemoryBlock;
import com.atmel.avr32.util.xml.IXMLNodeHandler;
import com.atmel.avr32.util.xml.XMLNodeHandler;
import org.xml.sax.SAXException;

public class XMLMemoryBlockHandler
extends XMLNodeHandler {
    private static final String NAME = "name";
    private static final String SIZE = "size";
    private static final String ADDRESS = "address";
    private static final String TYPE = "type";
    private int state = 0;
    private MemoryBlock block;

    public XMLMemoryBlockHandler(MemoryBlock memory) {
        this.block = memory;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.state != 0) {
            this.addCharacters(new String(ch, start, length));
        }
    }

    public IXMLNodeHandler startElement(String qName) throws SAXException {
        if (qName.equals(NAME)) {
            this.state = 1;
        } else if (qName.equals(SIZE)) {
            this.state = 2;
        } else if (qName.equals(ADDRESS)) {
            this.state = 3;
        } else if (qName.equals(TYPE)) {
            this.state = 4;
        }
        return this;
    }

    public void endElement(String qName) throws SAXException {
        switch (this.state) {
            case 1: {
                this.block.setName(this.takeCharacters());
                break;
            }
            case 2: {
                this.block.setSize(this.takeCharacters());
                break;
            }
            case 3: {
                this.block.setAddress(this.takeCharacters());
                break;
            }
            case 4: {
                this.block.setMemoryType(this.takeCharacters());
            }
        }
        this.state = 0;
    }

    private class State {
        public static final int NONE = 0;
        public static final int NAME = 1;
        public static final int SIZE = 2;
        public static final int ADDRESS = 3;
        public static final int TYPE = 4;

        private State() {
        }
    }
}

