/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.internal;

import com.atmel.avr32.target.part.internal.XMLInterruptGroupHandler;
import com.atmel.avr32.target.part.internal.XMLRegisterHandler;
import com.atmel.avr32.target.part.model.InterruptController;
import com.atmel.avr32.target.part.model.InterruptRegister;
import com.atmel.avr32.util.xml.IXMLNodeHandler;
import com.atmel.avr32.util.xml.XMLNodeHandler;
import org.xml.sax.SAXException;

public class XMLInterruptControllerHandler
extends XMLNodeHandler {
    private static final String INTERRUPT_GRP = "interrupt_grp";
    private static final String ADDRESS = "address";
    private static final String REGISTER = "register";
    private int state = 0;
    private InterruptController interruptController;

    public XMLInterruptControllerHandler(InterruptController intc) {
        this.interruptController = intc;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.state != 0) {
            this.addCharacters(new String(ch, start, length));
        }
    }

    public void endElement(String name) throws SAXException {
        switch (this.state) {
            case 1: {
                this.interruptController.setAddress(this.takeCharactersAsLong());
            }
        }
        this.state = 0;
    }

    public IXMLNodeHandler startElement(String qName) throws SAXException {
        if (qName.equals(INTERRUPT_GRP)) {
            return new XMLInterruptGroupHandler(this.interruptController);
        }
        if (qName.equals(ADDRESS)) {
            this.state = 1;
        } else if (qName.equals(REGISTER)) {
            InterruptRegister r = new InterruptRegister(this.interruptController);
            this.interruptController.addCauseRegister(r);
            return new XMLRegisterHandler(r);
        }
        return this;
    }

    private class State {
        public static final int NONE = 0;
        public static final int ADDRESS = 1;

        private State() {
        }
    }
}

