/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.internal;

import com.atmel.avr32.target.part.internal.XMLIOModuleInstanceMemoryRangeHandler;
import com.atmel.avr32.target.part.internal.XMLParameterHandler;
import com.atmel.avr32.target.part.model.IOModuleInstance;
import com.atmel.avr32.target.part.model.IOModuleInstanceMemoryRange;
import com.atmel.avr32.util.xml.IXMLNodeHandler;
import com.atmel.avr32.util.xml.XMLNodeHandler;
import org.xml.sax.SAXException;

public class XMLIOModuleInstanceHandler
extends XMLNodeHandler {
    private boolean capture;
    private IOModuleInstance instance;
    private static final String PARAMETER = "parameter";
    private static final String INSTANCE = "instance";
    private static final String NAME = "name";
    private static final String MEMORY_RANGE = "memory_range";

    public XMLIOModuleInstanceHandler(IOModuleInstance i) {
        this.instance = i;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.capture) {
            this.addCharacters(new String(ch, start, length));
        }
    }

    public void endElement(String qName) throws SAXException {
        if (this.capture) {
            this.instance.setName(this.takeCharacters());
        } else if (qName.equals(INSTANCE)) {
            this.instance.populateInstance();
        }
        this.capture = false;
    }

    public IXMLNodeHandler startElement(String qName) throws SAXException {
        if (qName.equals(NAME)) {
            this.capture = true;
        } else {
            if (qName.equals(PARAMETER)) {
                return new XMLParameterHandler(this.instance);
            }
            if (qName.equals(MEMORY_RANGE)) {
                IOModuleInstanceMemoryRange range = new IOModuleInstanceMemoryRange();
                this.instance.addMemoryRange(range);
                return new XMLIOModuleInstanceMemoryRangeHandler(range);
            }
        }
        return this;
    }
}

