/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.internal;

import com.atmel.avr32.target.part.internal.XMLIOModuleInstanceHandler;
import com.atmel.avr32.target.part.internal.XMLRegisterGroupHandler;
import com.atmel.avr32.target.part.internal.XMLRegisterHandler;
import com.atmel.avr32.target.part.model.IOModule;
import com.atmel.avr32.target.part.model.IOModuleInstance;
import com.atmel.avr32.target.part.model.Register;
import com.atmel.avr32.target.part.model.RegisterGroup;
import com.atmel.avr32.util.xml.IXMLNodeHandler;
import com.atmel.avr32.util.xml.XMLNodeHandler;
import org.xml.sax.SAXException;

public class XMLIOModuleHandler
extends XMLNodeHandler {
    private static final String REGISTER_GROUP = "register_group";
    private static final String REGISTER_GROUPS = "register_groups";
    private static final String INSTANCE = "instance";
    private static final String INSTANCES = "instances";
    private static final String REGISTER = "register";
    private static final String REGISTERS = "registers";
    private static final String TEXT = "text";
    private static final String NAME = "name";
    private int state = 0;
    private IOModule ioModule;

    public XMLIOModuleHandler(IOModule m) {
        this.ioModule = m;
    }

    public IXMLNodeHandler startElement(String qName) throws SAXException {
        if (qName.equals(NAME)) {
            this.state = 1;
            return this;
        }
        if (qName.equals(TEXT)) {
            this.state = 2;
            return this;
        }
        if (qName.equals(REGISTER)) {
            Register r = new Register(this.ioModule);
            XMLRegisterHandler rh = new XMLRegisterHandler(r);
            this.ioModule.addRegister(r);
            return rh;
        }
        if (qName.equals(INSTANCE)) {
            if (this.ioModule.getRegisters().size() > 0 || this.ioModule.getRegisterGroups().size() > 0) {
                return new XMLIOModuleInstanceHandler(new IOModuleInstance(this.ioModule));
            }
        } else {
            if (qName.equals(REGISTER_GROUP)) {
                return new XMLRegisterGroupHandler(new RegisterGroup(this.ioModule));
            }
            if (qName.equals(REGISTERS) || qName.equals(INSTANCES) || qName.equals(REGISTER_GROUPS)) {
                this.state = 0;
                return this;
            }
        }
        return new XMLNodeHandler();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.state != 0) {
            this.addCharacters(new String(ch, start, length));
        }
    }

    public void endElement(String qName) throws SAXException {
        switch (this.state) {
            case 1: {
                this.ioModule.setName(this.takeCharacters());
                break;
            }
            case 2: {
                this.ioModule.setText(this.takeCharacters());
            }
        }
        this.state = 0;
    }

    private class State {
        public static final int NONE = 0;
        public static final int NAME = 1;
        public static final int TEXT = 2;

        private State() {
        }
    }
}

