/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.internal;

import com.atmel.avr32.target.part.internal.XMLBitFieldValueHandler;
import com.atmel.avr32.target.part.model.Bitfield;
import com.atmel.avr32.target.part.model.BitfieldValue;
import com.atmel.avr32.util.xml.IXMLNodeHandler;
import com.atmel.avr32.util.xml.XMLNodeHandler;
import org.xml.sax.SAXException;

public class XMLBitfieldHandler
extends XMLNodeHandler {
    private static final String BIT_VALUE = "bit_value";
    private static final String ACCESS = "access";
    private static final String TEXT = "text";
    private static final String NAME = "name";
    private static final String SIZE = "size";
    private static final String NUMBER = "number";
    private int state = 0;
    private Bitfield bitfield;

    public XMLBitfieldHandler(Bitfield bf) {
        this.bitfield = bf;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.state != 0) {
            this.addCharacters(new String(ch, start, length));
        }
    }

    public void endElement(String qName) throws SAXException {
        switch (this.state) {
            case 1: {
                this.bitfield.setNumber(this.takeCharactersAsInteger());
                break;
            }
            case 2: {
                this.bitfield.setSize(this.takeCharactersAsInteger());
                break;
            }
            case 3: {
                this.bitfield.setName(this.takeCharacters());
                break;
            }
            case 4: {
                this.bitfield.setText(this.takeCharacters());
                break;
            }
            case 5: {
                this.bitfield.setReadonly(this.takeCharacters().indexOf("W") <= -1);
            }
        }
        this.state = 0;
    }

    public IXMLNodeHandler startElement(String qName) throws SAXException {
        if (qName == NUMBER) {
            this.state = 1;
        } else if (qName == SIZE) {
            this.state = 2;
        } else if (qName == NAME) {
            this.state = 3;
        } else if (qName == TEXT) {
            this.state = 4;
        } else if (qName == ACCESS) {
            this.state = 5;
        } else if (qName == BIT_VALUE) {
            BitfieldValue bfv = new BitfieldValue();
            XMLBitFieldValueHandler bfvh = new XMLBitFieldValueHandler(bfv);
            this.bitfield.addBitfieldValue(bfv);
            return bfvh;
        }
        return this;
    }

    private class State {
        public static final int NONE = 0;
        public static final int NUMBER = 1;
        public static final int SIZE = 2;
        public static final int NAME = 3;
        public static final int TEXT = 4;
        public static final int ACCESS = 5;

        private State() {
        }
    }
}

