/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.internal;

import com.atmel.avr32.target.part.model.BitfieldValue;
import com.atmel.avr32.util.xml.IXMLNodeHandler;
import com.atmel.avr32.util.xml.XMLNodeHandler;
import org.xml.sax.SAXException;

public class XMLBitFieldValueHandler
extends XMLNodeHandler {
    private static final String VALUE = "value";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private int state = 0;
    private BitfieldValue bitfieldValue;

    public XMLBitFieldValueHandler(BitfieldValue bfv) {
        this.bitfieldValue = bfv;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.state != 0) {
            this.addCharacters(new String(ch, start, length));
        }
    }

    public void endElement(String qName) throws SAXException {
        switch (this.state) {
            case 1: {
                this.bitfieldValue.setValue(this.takeCharactersAsInteger());
                break;
            }
            case 2: {
                this.bitfieldValue.setName(this.takeCharacters());
                break;
            }
            case 3: {
                String description = this.takeCharacters();
                if (description.startsWith("The output data for the corresponding pin is programmed to 0.")) {
                    description = "yes";
                } else if (description.startsWith("The output data for the corresponding pin is programmed to 1.")) {
                    description = "no";
                }
                this.bitfieldValue.setDescription(description);
            }
        }
        this.state = 0;
    }

    public IXMLNodeHandler startElement(String qName) throws SAXException {
        if (qName.equals(VALUE)) {
            this.state = 1;
        } else if (qName.equals(NAME)) {
            this.state = 2;
        } else if (qName.equals(DESCRIPTION)) {
            this.state = 3;
        }
        return this;
    }

    private class State {
        public static final int NONE = 0;
        public static final int VALUE = 1;
        public static final int NAME = 2;
        public static final int DESCRIPTION = 3;

        private State() {
        }
    }
}

