/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.part.internal;

import com.atmel.avr32.target.part.model.Fuse;
import com.atmel.avr32.target.part.model.FuseValue;
import com.atmel.avr32.target.part.model.Part;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class FuseFileParser
extends DefaultHandler {
    Part part = null;
    Fuse fuse = null;
    FuseValue setting = null;
    boolean captureCDATA;
    StringBuffer sb;
    boolean hasErrors;
    boolean hasWarnings;
    StringBuffer errorMessages;
    StringBuffer warningMessages;

    public FuseFileParser(Part part) {
        this.part = part;
        this.sb = new StringBuffer();
        this.errorMessages = new StringBuffer();
        this.warningMessages = new StringBuffer();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String value;
        String name;
        int a;
        if (this.captureCDATA) {
            this.sb.append("<" + qName);
            if (atts.getLength() > 0) {
                a = 0;
                while (a < atts.getLength()) {
                    name = atts.getQName(a);
                    value = atts.getValue(a);
                    this.sb.append(" ");
                    this.sb.append(name);
                    this.sb.append("='");
                    this.sb.append(value);
                    this.sb.append("'");
                    ++a;
                }
            }
            this.sb.append(">");
        }
        if (qName.equals("fuse")) {
            this.fuse = new Fuse();
            a = 0;
            while (a < atts.getLength()) {
                name = atts.getQName(a);
                value = atts.getValue(a);
                if (name.equals("name")) {
                    this.fuse.setName(value);
                }
                if (name.equals("title")) {
                    this.fuse.setTitle(value);
                }
                if (name.equals("label")) {
                    this.fuse.setLabel(value);
                }
                if (name.equals("length")) {
                    this.fuse.setLength(Integer.parseInt(value));
                }
                if (name.equals("offset")) {
                    this.fuse.setOffset(Integer.parseInt(value));
                }
                if (name.equals("group")) {
                    this.fuse.setGroup(value);
                }
                if (name.equals("type")) {
                    if (value.equals("toggle")) {
                        this.fuse.setType(Fuse.FuseValueType.TOGGLE);
                    }
                    if (value.equals("enumeration")) {
                        this.fuse.setType(Fuse.FuseValueType.ENUMERATION);
                    }
                    if (value.equals("number")) {
                        this.fuse.setType(Fuse.FuseValueType.NUMBER);
                    }
                }
                ++a;
            }
        }
        if (qName.equals("setting")) {
            this.setting = new FuseValue();
            a = 0;
            while (a < atts.getLength()) {
                name = atts.getQName(a);
                value = atts.getValue(a);
                if (name.equals("value")) {
                    this.setting.setNumeric(Long.decode(value));
                }
                if (name.equals("label")) {
                    this.setting.setDescription(value);
                }
                ++a;
            }
        }
        if (qName.equals("description")) {
            this.sb.setLength(0);
            this.captureCDATA = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("fuse")) {
            this.part.addFuse(this.fuse);
        }
        if (qName.equals("setting")) {
            this.fuse.addValue(this.setting);
        }
        if (qName.equals("description")) {
            this.captureCDATA = false;
            this.fuse.setDescription(this.sb.toString().trim());
        }
        if (this.captureCDATA) {
            this.sb.append("</" + qName + ">");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.captureCDATA) {
            int p = start;
            while (p < start + length) {
                char c = ch[p];
                if (c == '\n' || c == '\r' || c == '\t') {
                    c = ' ';
                }
                if (c != ' ' || this.sb.length() <= 0 || this.sb.charAt(this.sb.length() - 1) != ' ') {
                    this.sb.append(c);
                }
                ++p;
            }
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.errorMessages.append("\nAt line " + e.getLineNumber() + ": " + e.getMessage());
        this.hasErrors = true;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.warningMessages.append("\nAt line " + e.getLineNumber() + ": " + e.getMessage());
        this.hasWarnings = true;
    }

    public StringBuffer getErrorMessages() {
        return this.errorMessages;
    }

    public StringBuffer getWarningMessages() {
        return this.warningMessages;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }
}

