/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.launch;

import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;

public abstract class StreamConsumer
implements IStreamListener {
    private Thread fThread;
    private boolean echo = true;
    InputStreamReader processOutput;
    IProgressMonitor fMonitor;
    IStreamMonitor fStreamMonitor;
    Process fProcess;
    IProcess fIProcess;
    StringBuffer fStrings = new StringBuffer();
    private boolean done;

    protected synchronized void setEchoing(boolean echo) {
        this.echo = echo;
    }

    protected synchronized boolean isEchoing() {
        return this.echo;
    }

    public String getResult() {
        if (this.fIProcess != null) {
            while (!this.fIProcess.isTerminated()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.closeStream();
        }
        if (this.fProcess != null) {
            while (!this.isDone()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.fStrings.toString();
    }

    public abstract void read();

    public synchronized void streamAppended(String text, IStreamMonitor monitor) {
        this.fStrings.append(text);
    }

    protected void startMonitoring() {
        if (this.fThread == null) {
            this.fThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    StreamConsumer.this.read();
                }
            });
            this.fThread.setDaemon(true);
            this.fThread.setPriority(5);
            this.fThread.start();
        }
    }

    protected void close() {
        try {
            this.done = true;
            try {
                if (this.processOutput != null) {
                    this.processOutput.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Thread thread = this.fThread;
            this.fThread = null;
            thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected boolean isDone() {
        block3: {
            try {
                if (this.fProcess != null) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        this.fProcess.exitValue();
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStream() {
        if (this.fStreamMonitor == null) {
            return;
        }
        IStreamMonitor iStreamMonitor = this.fStreamMonitor;
        synchronized (iStreamMonitor) {
            this.fStreamMonitor.removeListener((IStreamListener)this);
        }
    }
}

