/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.launch;

import com.atmel.avr32.target.launch.StreamConsumer;
import com.atmel.avr32.util.UtilPlugin;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;

public class ErrorStreamConsumer
extends StreamConsumer {
    private static final String UNKNOWN = "?";
    private static final String READY = "%ready";
    private static final String DONE = "%done";
    private static final String SPACE = " ";
    private static final String PERCENT = "%";
    private static final String NEWLINE = System.getProperty("line.separator");
    StringBuffer buffer;
    private int previous;
    private boolean done;

    public ErrorStreamConsumer(Process process, IProgressMonitor monitor) {
        this.fProcess = process;
        this.fMonitor = monitor;
        this.buffer = new StringBuffer();
        this.processOutput = new InputStreamReader(process.getErrorStream());
        this.fMonitor = monitor;
        this.startMonitoring();
    }

    public ErrorStreamConsumer(IProgressMonitor monitor, IProcess process) {
        this.fIProcess = process;
        this.fMonitor = monitor;
        this.buffer = new StringBuffer();
        this.fStreamMonitor = this.fIProcess.getStreamsProxy().getErrorStreamMonitor();
        this.setEchoing(false);
        this.fStreamMonitor.addListener((IStreamListener)this);
        this.monitor(this.fStreamMonitor.getContents());
    }

    @Override
    public synchronized void streamAppended(String text, IStreamMonitor monitor) {
        this.buffer.append(text);
        while (this.buffer.indexOf(NEWLINE) > -1) {
            try {
                this.monitor(this.buffer.substring(0, this.buffer.indexOf(NEWLINE)));
                this.buffer.delete(0, this.buffer.indexOf(NEWLINE) + NEWLINE.length());
                this.buffer.trimToSize();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void read() {
        try {
            int c = this.processOutput.read();
            int start = 0;
            while (c != -1) {
                this.buffer.append((char)c);
                if (c == 10) {
                    this.monitor(this.buffer.substring(start));
                    start = this.buffer.length();
                }
                c = this.processOutput.read();
            }
            this.close();
        }
        catch (IOException iOException) {}
    }

    private synchronized void monitor(String string) {
        if (!string.startsWith(PERCENT)) {
            this.fStrings.append(string.trim());
            this.fStrings.append(NEWLINE);
            if (this.isEchoing()) {
                UtilPlugin.println((Object)string.trim());
            }
        } else {
            String[] parts = string.split(SPACE);
            if (string.startsWith(READY) || string.startsWith(DONE)) {
                this.done = true;
            } else if (parts[0].substring(1).startsWith(UNKNOWN)) {
                if (string.indexOf(SPACE) > -1) {
                    this.fMonitor.subTask(string.substring(string.indexOf(SPACE)));
                }
            } else {
                int worked;
                int progress = (int)Math.floor(Float.parseFloat(parts[0].substring(1)));
                if (progress < this.previous) {
                    this.fMonitor.worked(100 - this.previous);
                    this.previous = 0;
                }
                if (this.fMonitor != null && (worked = progress - this.previous) > 0) {
                    this.fMonitor.subTask(string.substring(string.indexOf(SPACE)));
                    this.fMonitor.worked(worked);
                    this.previous = progress;
                }
            }
        }
    }

    @Override
    public boolean isDone() {
        return this.done || super.isDone();
    }
}

