/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.internal;

import com.atmel.avr32.target.tool.model.Capability;
import com.atmel.avr32.target.tool.model.Clock;
import com.atmel.avr32.target.tool.model.Interface;
import com.atmel.avr32.target.tool.model.Memory;
import com.atmel.avr32.target.tool.model.Tool;
import com.atmel.avr32.target.tool.model.Voltage;
import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ToolExtensionPointReader {
    private static final String PROVIDES = "provides";
    private static final String SOURCE = "source";
    private static final String AND = "and";
    private static final String REQUIRES = "requires";
    private static final String CAPABILITY = "capability";
    private static final String CLOCK = "clock";
    private static final String VOLTAGE = "voltage";
    private static final String BOARD = "board";
    private static final String ADAPTER = "adapter";
    private static final String INTERFACE = "interface";
    private static final String STEPS = "steps";
    private static final String MAX = "max";
    private static final String MIN = "min";
    private static final String WRITABLE = "writable";
    private static final String ADDRESS = "address";
    private static final String SIZE = "size";
    private static final String TYPE = "type";
    private static final String ID = "id";
    private static final String MEMORY = "memory";
    private static final String PART_ID = "part-id";
    private static final String NAME = "name";
    private static final String TOOL = "tool";
    private static final String TOOLS_EXTENSIONPOINT_ID = "com.atmel.avr32.target.tools";
    private static final int SECTION_ADAPTER = 0;
    private static final int SECTION_BOARD = 1;
    private int section;

    private Attribute[] getAttributes(IConfigurationElement element) {
        String[] names = element.getAttributeNames();
        Attribute[] attributes = new Attribute[element.getAttributeNames().length];
        int a = 0;
        while (a < names.length) {
            Attribute attribute = new Attribute();
            attribute.name = names[a];
            attribute.value = element.getAttribute(names[a]);
            attributes[a] = attribute;
            ++a;
        }
        return attributes;
    }

    private void handleElement(IConfigurationElement element, Tool tool) {
        Attribute[] attributes = this.getAttributes(element);
        this.startElement(element, element.getName(), tool, attributes);
        IConfigurationElement[] iConfigurationElementArray = element.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            this.handleElement(child, tool);
            ++n2;
        }
    }

    public ArrayList<Tool> getTools() {
        IConfigurationElement[] points;
        ArrayList<Tool> tools = new ArrayList<Tool>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(TOOLS_EXTENSIONPOINT_ID);
        IConfigurationElement[] iConfigurationElementArray = points = extensionPoint.getConfigurationElements();
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            Tool tool = new Tool(element);
            try {
                this.handleElement(element, tool);
                tools.add(tool);
            }
            catch (Exception e) {
                System.err.println("Could not add tool from \"" + element.getName() + "\"");
                e.printStackTrace();
            }
            ++n2;
        }
        return tools;
    }

    private void startElement(IConfigurationElement element, String qName, Tool tool, Attribute[] atts) {
        String value;
        String name;
        if (qName.equals(TOOL)) {
            int a = 0;
            while (a < atts.length) {
                String name2 = atts[a].name;
                String value2 = atts[a].value;
                if (name2.equals(PART_ID)) {
                    tool.setPartID(value2);
                }
                ++a;
            }
            Capability toolcap = new Capability();
            toolcap.setId(tool.getId());
            toolcap.setName(tool.getName());
            tool.addCapability(toolcap);
        }
        if (qName.equals(MEMORY)) {
            Memory m = new Memory();
            int a = 0;
            while (a < atts.length) {
                name = atts[a].name;
                value = atts[a].value;
                if (name.equals(ID)) {
                    m.setId(Integer.parseInt(value));
                }
                if (name.equals(TYPE)) {
                    m.setType(value);
                }
                if (name.equals(NAME)) {
                    m.setName(value);
                }
                if (name.equals(SIZE)) {
                    m.setSize(value);
                }
                if (name.equals(ADDRESS)) {
                    m.setAddress(value);
                }
                if (name.equals(PART_ID)) {
                    m.setPartID(value);
                }
                ++a;
            }
            tool.addMemory(m);
        }
        if (qName.equals(VOLTAGE)) {
            Voltage voltage = new Voltage();
            int a = 0;
            while (a < atts.length) {
                name = atts[a].name;
                value = atts[a].value;
                if (name.equals(ID)) {
                    voltage.setId(value);
                }
                if (name.equals(NAME)) {
                    voltage.setName(value);
                }
                if (name.equals(TYPE)) {
                    voltage.setType(value);
                }
                if (name.equals(WRITABLE)) {
                    voltage.setWritable(Boolean.parseBoolean(value));
                }
                if (name.equals(MIN)) {
                    voltage.setMinVoltage(Float.parseFloat(value));
                }
                if (name.equals(MAX)) {
                    voltage.setMaxVoltage(Float.parseFloat(value));
                }
                if (name.equals(STEPS)) {
                    voltage.setVoltageStep(Float.parseFloat(value));
                }
                ++a;
            }
            if (this.section == 0) {
                tool.addVoltage(voltage);
            }
        }
        if (qName.equals(CLOCK)) {
            Clock clock = new Clock();
            int a = 0;
            while (a < atts.length) {
                name = atts[a].name;
                value = atts[a].value;
                if (name.equals(ID)) {
                    clock.setId(value);
                }
                if (name.equals(NAME)) {
                    clock.setName(value);
                }
                if (name.equals(TYPE)) {
                    clock.setType(value);
                }
                if (name.equals(WRITABLE)) {
                    clock.setWritable(Boolean.parseBoolean(value));
                }
                if (name.equals(MIN)) {
                    clock.setMinFrequency(Long.parseLong(value));
                }
                if (name.equals(MAX)) {
                    clock.setMaxFrequency(Long.parseLong(value));
                }
                if (name.equals(STEPS)) {
                    clock.setFrequencyStep(Integer.parseInt(value));
                }
                ++a;
            }
            tool.addClock(clock);
        }
        if (qName.equals(PROVIDES)) {
            tool.getCapabilities().addAll(this.retrieveCapabilities(element));
        }
        if (qName.equals(INTERFACE)) {
            Interface inter = new Interface();
            int a = 0;
            while (a < atts.length) {
                name = atts[a].name;
                value = atts[a].value;
                if (name.equals(TYPE)) {
                    inter.setType(value);
                }
                ++a;
            }
            tool.addInterface(inter);
        }
        if (qName.equals(ADAPTER)) {
            tool.setType(tool.getType() | 1);
            this.section = 0;
        }
        if (qName.equals(BOARD)) {
            tool.setType(tool.getType() | 2);
            this.section = 1;
        }
    }

    private ArrayList<Capability> retrieveCapabilities(IConfigurationElement root) {
        IConfigurationElement[] children;
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        IConfigurationElement[] iConfigurationElementArray = children = root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement capabilityElement = iConfigurationElementArray[n2];
            if (capabilityElement.getName().equals(CAPABILITY)) {
                Attribute[] attributes = this.getAttributes(capabilityElement);
                Capability capability = new Capability();
                int a = 0;
                while (a < attributes.length) {
                    String name = attributes[a].name;
                    String value = attributes[a].value;
                    if (name.equals(NAME)) {
                        capability.setName(value);
                    }
                    if (name.equals(ID)) {
                        capability.setId(value);
                    }
                    if (name.equals(SOURCE)) {
                        if (value.equals(BOARD)) {
                            capability.setBoard(true);
                        } else {
                            capability.setBoard(false);
                        }
                    }
                    ++a;
                }
                if (capabilityElement.getChildren(REQUIRES).length > 0) {
                    capability.setRequires(this.retrieveCapabilities(capabilityElement.getChildren(REQUIRES)[0]));
                }
                capabilities.add(capability);
            }
            if (capabilityElement.getName().equals(AND)) {
                Capability capability = new Capability();
                capability.setAndCollection(true);
                capability.setRequires(this.retrieveCapabilities(capabilityElement));
                capabilities.add(capability);
            }
            ++n2;
        }
        return capabilities;
    }

    private class Attribute {
        protected String name;
        protected String value;

        private Attribute() {
        }
    }
}

