/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.internal;

import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.internal.TargetManager;
import java.util.Date;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class TargetPropertySource
implements IPropertySource {
    public static final String PROPERTY_NAME = "target.name";
    public static final String PROPERTY_CPU = "target.cpu";
    public static final String PROPERTY_BOARD = "target.board";
    public static final String PROPERTY_ADAPTER = "target.adapter";
    public static final String PROPERTY_SERIAL = "target.serial";
    public static final String PROPERTY_COMPORT = "target.comport";
    public static final String PROPERTY_CONNECTION_TYPE = "target.connection";
    public static final String PROPERTY_DESCRIPTION = "target.description";
    public static final String PROPERTY_BIN_NAME = "target.binary.name";
    public static final String PROPERTY_BIN_DATE = "target.binary.date";
    public static final String PROPERTY_MCU_CLOCK = "target.mcu.clock";
    public static final String PROPERTY_DAISY_DEVS_BEFORE = "target.daisy.devsbefore";
    public static final String PROPERTY_DAISY_DEVS_AFTER = "target.daisy.devsafter";
    public static final String PROPERTY_DAISY_BITS_BEFORE = "target.daisy.bitsbefore";
    public static final String PROPERTY_DAISY_BITS_AFTER = "target.daisy.bitsafter";
    public static final String PROPERTY_DAISY_ENABLED = "target.daisy.enabled";
    private ITarget description;

    public TargetPropertySource(ITarget description) {
        this.description = description;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public Object getEditableValue() {
        return null;
    }

    public Object getPropertyValue(Object id) {
        if (PROPERTY_NAME.equals(id)) {
            return this.description.getName();
        }
        if (PROPERTY_SERIAL.equals(id)) {
            return this.description.getSerial();
        }
        if (PROPERTY_COMPORT.equals(id)) {
            return this.description.getComport();
        }
        if (PROPERTY_ADAPTER.equals(id)) {
            return this.description.getAdapterName();
        }
        if (PROPERTY_BOARD.equals(id)) {
            return this.description.getBoardName();
        }
        if (PROPERTY_CPU.equals(id)) {
            return this.description.getCpu();
        }
        if (PROPERTY_CONNECTION_TYPE.equals(id)) {
            return this.description.getConnectionType();
        }
        if (PROPERTY_DESCRIPTION.equals(id)) {
            return this.description.getDescription();
        }
        if (PROPERTY_BIN_NAME.equals(id)) {
            return this.description.getLastBinary();
        }
        if (PROPERTY_BIN_DATE.equals(id)) {
            return new Date(this.description.getLastBinaryDateTime());
        }
        if (PROPERTY_MCU_CLOCK.equals(id)) {
            return new Integer(this.description.getClockSource());
        }
        if (PROPERTY_DAISY_ENABLED.equals(id)) {
            return this.description.isDaisyChainConfigured();
        }
        if (PROPERTY_DAISY_DEVS_BEFORE.equals(id)) {
            return this.description.getDaisyDevsBefore();
        }
        if (PROPERTY_DAISY_DEVS_AFTER.equals(id)) {
            return this.description.getDaisyDevsAfter();
        }
        if (PROPERTY_DAISY_BITS_BEFORE.equals(id)) {
            return this.description.getDaisyBitsBefore();
        }
        if (PROPERTY_DAISY_BITS_AFTER.equals(id)) {
            return this.description.getDaisyBitsAfter();
        }
        return null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_NAME.equals(id)) {
            this.description.setName(value.toString());
        }
        if (PROPERTY_ADAPTER.equals(id)) {
            this.description.setAdapterName(value.toString());
        }
        if (PROPERTY_BOARD.equals(id)) {
            this.description.setBoardName(value.toString());
        }
        if (PROPERTY_CPU.equals(id)) {
            this.description.setCpu(value.toString());
        }
        if (PROPERTY_SERIAL.equals(id)) {
            this.description.setSerial(value.toString());
        }
        if (PROPERTY_COMPORT.equals(id)) {
            this.description.setComport(value.toString());
        }
        if (PROPERTY_CONNECTION_TYPE.equals(id)) {
            this.description.setConnectionType(value.toString());
        }
        if (PROPERTY_DESCRIPTION.equals(id)) {
            this.description.setDescription(value.toString());
        }
        if (PROPERTY_MCU_CLOCK.equals(id)) {
            this.description.setClockSource((Integer)value);
        }
        if (PROPERTY_DAISY_ENABLED.equals(id)) {
            this.description.enableDaisyChain((Boolean)value);
        }
        if (PROPERTY_DAISY_DEVS_BEFORE.equals(id)) {
            this.description.setDaisyDevsBefore((Integer)value);
        }
        if (PROPERTY_DAISY_DEVS_AFTER.equals(id)) {
            this.description.setDaisyDevsAfter((Integer)value);
        }
        if (PROPERTY_DAISY_BITS_BEFORE.equals(id)) {
            this.description.setDaisyBitsBefore((Integer)value);
        }
        if (PROPERTY_DAISY_BITS_AFTER.equals(id)) {
            this.description.setDaisyBitsAfter((Integer)value);
        }
        TargetManager.getDefault().updateTarget(this.description);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return null;
    }
}

