/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.internal;

import com.atmel.avr32.target.ITarget;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.ITargetManager;
import com.atmel.avr32.target.ITargetModifiedListener;
import com.atmel.avr32.target.PartRegistry;
import com.atmel.avr32.target.Target;
import com.atmel.avr32.target.TargetJob;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.internal.Messages;
import com.atmel.avr32.target.internal.TargetDeserializer;
import com.atmel.avr32.target.internal.XMLWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class TargetManager
implements IJobChangeListener,
ITargetManager {
    private static final String DEFAULT_BOARD = "Unspecified";
    private static ArrayList<TargetJob> fSleepers = new ArrayList();
    private static ArrayList<ITarget> fTargets = new ArrayList();
    private static final int JOB_INTERVAL = 3000;
    private static TargetManager manager;
    private static ListenerList targetChangedListeners;
    static ITargetInterface targetInterface;
    private static final String TARGETS = "targets";

    public static TargetManager getDefault() {
        if (manager == null) {
            manager = new TargetManager();
        }
        return manager;
    }

    private TargetManager() {
        this.readTargets();
        fSleepers = new ArrayList();
        targetChangedListeners = new ListenerList();
    }

    public void aboutToRun(IJobChangeEvent event) {
        Job j = event.getJob();
        if (j instanceof TargetJob) {
            ITarget td = ((TargetJob)j).getTarget();
            if (td.isWorking()) {
                j.sleep();
                fSleepers.add((TargetJob)j);
            }
            this.notifyTargetModifiedListeners(td);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addTarget(ITarget td) {
        ArrayList<ITarget> arrayList = fTargets;
        synchronized (arrayList) {
            int id = this.getNextId();
            td.setId(id);
            this.writeTarget(td);
            fTargets.add(td);
            this.notifyTargetModifiedListeners(null);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ITarget addTarget(String adapter, String serial) {
        ArrayList<ITarget> arrayList = fTargets;
        synchronized (arrayList) {
            ITarget t2;
            for (ITarget t2 : fTargets) {
                if (!t2.getAdapterName().equals(adapter) || !t2.getSerial().equals(serial)) continue;
                return t2;
            }
            t2 = new Target(adapter, serial);
            t2.setBoardName(DEFAULT_BOARD);
            t2.setDetected(true);
            t2.setAdapterName(adapter);
            return this.getTarget(this.addTarget(t2));
        }
    }

    public void addTargetModifiedListener(ITargetModifiedListener listener) {
        targetChangedListeners.add((Object)listener);
    }

    public void awake(IJobChangeEvent event) {
        Job j = event.getJob();
        if (j instanceof TargetJob) {
            ITarget td = ((TargetJob)j).getTarget();
            this.notifyTargetModifiedListeners(td);
        }
    }

    public void done(IJobChangeEvent event) {
        Job j = event.getJob();
        if (j instanceof TargetJob) {
            ITarget td = ((TargetJob)j).getTarget();
            j = null;
            this.releaseTarget(td);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITarget getDefaultTarget() {
        ITarget defaultTarget = null;
        ArrayList<ITarget> arrayList = fTargets;
        synchronized (arrayList) {
            for (ITarget target : fTargets) {
                if (!target.isDefault()) continue;
                defaultTarget = target;
            }
        }
        return defaultTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextId() {
        ArrayList<ITarget> arrayList = fTargets;
        synchronized (arrayList) {
            int id = 0;
            for (ITarget td : fTargets) {
                if (td.getId() <= id) continue;
                id = td.getId();
            }
            return id + 1;
        }
    }

    private File getRepository() {
        return TargetPlugin.getDefault().getStateLocation().append(TARGETS).toFile();
    }

    private File getRepositoryFile(int id) {
        return TargetPlugin.getDefault().getStateLocation().append(TARGETS).append(Integer.toString(id)).toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITarget getTarget(int id) {
        ArrayList<ITarget> arrayList = fTargets;
        synchronized (arrayList) {
            for (ITarget t : fTargets) {
                if (t.getId() != id) continue;
                return t;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITarget getTarget(String name, String serial) {
        ArrayList<ITarget> arrayList = fTargets;
        synchronized (arrayList) {
            for (ITarget target : fTargets) {
                if (!target.getAdapterName().equals(name) || !target.getSerial().equals(serial)) continue;
                return target;
            }
        }
        return null;
    }

    @Override
    public ITarget[] getTargets() {
        return fTargets.toArray(new Target[fTargets.size()]);
    }

    private void notifyTargetModifiedListeners(ITarget target) {
        Object[] objectArray = targetChangedListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            if (listener instanceof ITargetModifiedListener) {
                ((ITargetModifiedListener)listener).targetModified(target);
            }
            ++n2;
        }
    }

    private Target readTarget(File file) {
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        try {
            FileInputStream st = new FileInputStream(file);
            TargetDeserializer ts = new TargetDeserializer();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(ts);
            InputSource input = new InputSource(st);
            reader.parse(input);
            Target td = ts.getTarget();
            return td;
        }
        catch (SAXParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void readTargets() {
        File[] targetFiles;
        fTargets.clear();
        File dir = this.getRepository();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File[] fileArray = targetFiles = dir.listFiles();
        int n = targetFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            Target t = this.readTarget(file);
            if (t != null && this.getTarget(t.getId()) == null) {
                fTargets.add(t);
            }
            ++n2;
        }
    }

    @Override
    public void releaseTarget(ITarget target) {
        target.setWorking(false);
        for (TargetJob job : fSleepers) {
            if (job.getTarget().getId() != target.getId()) continue;
            fSleepers.remove((Object)job);
            job.wakeUp(3000L);
            break;
        }
        this.notifyTargetModifiedListeners(target);
    }

    @Override
    public void reload() {
        fTargets.clear();
        this.readTargets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeTarget(ITarget target) {
        ArrayList<ITarget> arrayList = fTargets;
        synchronized (arrayList) {
            fTargets.remove(target);
            File targetFile = this.getRepositoryFile(target.getId());
            targetFile.delete();
            this.notifyTargetModifiedListeners(target);
            if (fTargets.size() == 1 || target.isDefault() && fTargets.size() > 1) {
                fTargets.get(0).setDefault(true);
                this.notifyTargetModifiedListeners(fTargets.get(0));
            }
        }
    }

    public void removeTargetModifiedListener(ITargetModifiedListener listener) {
        targetChangedListeners.remove((Object)listener);
    }

    public void running(IJobChangeEvent event) {
        Job j = event.getJob();
        if (j instanceof TargetJob) {
            ((TargetJob)j).getTarget().setWorking(true);
            this.notifyTargetModifiedListeners(((TargetJob)j).getTarget());
        }
    }

    public void scheduled(IJobChangeEvent event) {
        this.notifyTargetModifiedListeners(((TargetJob)event.getJob()).getTarget());
    }

    public void sleeping(IJobChangeEvent event) {
        this.notifyTargetModifiedListeners(((TargetJob)event.getJob()).getTarget());
    }

    @Override
    public void updateTarget(ITarget target) {
        if (target.isDirty()) {
            this.writeTarget(target);
            target.setDirty(false);
        }
        this.notifyTargetModifiedListeners(target);
    }

    @Override
    public IStatus validateOperation(ITarget target, int operation) {
        if (target == null) {
            return new Status(4, "com.atmel.avr32.target", 0, Messages.TargetManager_NoTarget, null);
        }
        if (!target.isValid()) {
            return new Status(4, "com.atmel.avr32.target", 0, Messages.TargetManager_InvalidConfiguration, null);
        }
        if (target.isWorking()) {
            return new Status(2, "com.atmel.avr32.target", 0, Messages.TargetManager_BusyTarget, null);
        }
        if (operation == 1 && PartRegistry.getPart(target.getCpu()).getFuses().size() == 0) {
            return new Status(2, "com.atmel.avr32.target", 0, Messages.TargetManager_NoFuses, null);
        }
        return Status.OK_STATUS;
    }

    private void writeTarget(ITarget target) {
        File dir = this.getRepository();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try {
            XMLWriter xmlw = new XMLWriter(new BufferedOutputStream(new FileOutputStream(this.getRepositoryFile(target.getId()))));
            xmlw.startTag("target", target.getAttributes());
            xmlw.printSimpleTag("description", target.getDescription());
            xmlw.endTag("target");
            xmlw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

