/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.internal;

import com.atmel.avr32.target.Target;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TargetDeserializer
extends DefaultHandler {
    Target target = new Target();
    private StringBuffer sb = new StringBuffer();
    private boolean captureCDATA;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("target")) {
            int a = 0;
            while (a < atts.getLength()) {
                String name = atts.getQName(a);
                String value = atts.getValue(a);
                if (name.equals("name")) {
                    this.target.setName(value);
                }
                if (name.equals("id")) {
                    this.target.setId(Integer.parseInt(value));
                }
                if (name.equals("cpu")) {
                    this.target.setCpu(value);
                }
                if (name.equals("adapter")) {
                    this.target.setAdapterName(value);
                }
                if (name.equals("board")) {
                    this.target.setBoardName(value);
                }
                if (name.equals("serial")) {
                    this.target.setSerial(value);
                }
                if (name.equals("binary")) {
                    this.target.setLastBinary(value);
                }
                if (name.equals("binary-date")) {
                    this.target.setLastBinaryDateTime(Long.parseLong(value));
                }
                if (name.equals("default")) {
                    this.target.setDefault(Boolean.parseBoolean(value));
                }
                if (name.equals("comport")) {
                    this.target.setComport(value);
                }
                if (name.equals("connection-type")) {
                    this.target.setConnectionType(value);
                }
                if (name.equals("clocksource")) {
                    this.target.setClockSource(Integer.parseInt(value));
                }
                if (name.equals("daisyenabled")) {
                    this.target.enableDaisyChain(Boolean.parseBoolean(value));
                }
                if (name.equals("daisydevsbefore")) {
                    this.target.setDaisyDevsBefore(Integer.parseInt(value));
                }
                if (name.equals("daisydevsafter")) {
                    this.target.setDaisyDevsAfter(Integer.parseInt(value));
                }
                if (name.equals("daisybitsbefore")) {
                    this.target.setDaisyBitsBefore(Integer.parseInt(value));
                }
                if (name.equals("daisybitsafter")) {
                    this.target.setDaisyBitsAfter(Integer.parseInt(value));
                }
                ++a;
            }
        }
        if (qName.equals("description")) {
            this.captureCDATA = true;
        }
    }

    public Target getTarget() {
        return this.target;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (qName.equals("description")) {
            this.target.setDescription(this.sb.toString());
            this.captureCDATA = false;
            this.sb.setLength(0);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.captureCDATA) {
            this.sb.append(new String(ch, start, length));
        }
    }
}

