/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.avr32.target.internal;

import com.atmel.avr32.target.ITargetAction;
import com.atmel.avr32.target.ITargetInterface;
import com.atmel.avr32.target.TargetPlugin;
import com.atmel.avr32.target.internal.Messages;
import com.atmel.avr32.target.tool.model.Capability;
import com.atmel.avr32.target.tool.model.TargetInterfaceDescription;
import com.atmel.avr32.target.ui.TargetAction;
import com.atmel.avr32.target.ui.TargetDialogAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class InterfaceExtensionPointReader {
    private static final String SCAN_PRIORITY = "scanPriority";
    private static final String HELP_CONTEXT_ID = "helpContextId";
    private static final String APPLIES_TO = "applies-to";
    private static final String SOURCE = "source";
    private static final String PROVIDES = "provides";
    private static final String AND = "and";
    private static final String REQUIRES = "requires";
    private static final String BOARD = "board";
    private static final String CLASS_ATTR = "class";
    private static final String COM_ATMEL_AVR32_TARGET_INTERFACES = "com.atmel.avr32.target.interfaces";
    private static final String NAME = "name";
    private static final String ACTION = "action";
    private static final String ID = "id";
    private static final String ICON = "icon";
    private static final String DIALOG = "dialog";
    private static final String CLASS = "class";
    private static final String TITLE = "title";
    private static final String LABEL = "label";
    private static final String COMMAND = "command";
    private static final String TOOLTIP = "tooltip";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String OPTION = "option";
    private static final String SUBMENU = "submenu";
    private static final String SHOW_PROGRESS = "showProgress";
    private static final String SHOW_RESULT = "showResult";
    private static final String CAPABILITY = "capability";

    private Attribute[] getAttributes(IConfigurationElement element) {
        String[] names = element.getAttributeNames();
        Attribute[] attributes = new Attribute[element.getAttributeNames().length];
        int a = 0;
        while (a < names.length) {
            Attribute attribute = new Attribute();
            attribute.name = names[a];
            attribute.value = element.getAttribute(names[a]);
            attributes[a] = attribute;
            ++a;
        }
        return attributes;
    }

    private ArrayList<Capability> retrieveCapabilities(IConfigurationElement root) {
        IConfigurationElement[] children;
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        IConfigurationElement[] iConfigurationElementArray = children = root.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement capabilityElement = iConfigurationElementArray[n2];
            if (capabilityElement.getName().equals(CAPABILITY)) {
                Attribute[] attributes = this.getAttributes(capabilityElement);
                Capability capability = new Capability();
                int a = 0;
                while (a < attributes.length) {
                    String name = attributes[a].name;
                    String value = attributes[a].value;
                    if (name.equals(NAME)) {
                        capability.setName(value);
                    }
                    if (name.equals(ID)) {
                        capability.setId(value);
                    }
                    if (name.equals(SOURCE)) {
                        if (value.equals(BOARD)) {
                            capability.setBoard(true);
                        } else {
                            capability.setBoard(false);
                        }
                    }
                    ++a;
                }
                if (capabilityElement.getChildren(REQUIRES).length > 0) {
                    capability.setRequires(this.retrieveCapabilities(capabilityElement.getChildren(REQUIRES)[0]));
                }
                capabilities.add(capability);
            }
            if (capabilityElement.getName().equals(AND)) {
                Capability capability = new Capability();
                capability.setAndCollection(true);
                capability.setRequires(this.retrieveCapabilities(capabilityElement));
                capabilities.add(capability);
            }
            ++n2;
        }
        return capabilities;
    }

    public HashMap<String, TargetInterfaceDescription> getTargetInterfaces() {
        IConfigurationElement[] interfaces;
        HashMap<String, TargetInterfaceDescription> targetInterfaces = new HashMap<String, TargetInterfaceDescription>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(COM_ATMEL_AVR32_TARGET_INTERFACES);
        IConfigurationElement[] iConfigurationElementArray = interfaces = extensionPoint.getConfigurationElements();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement interFace = iConfigurationElementArray[n2];
            try {
                String id = interFace.getAttribute(ID);
                int priority = 50;
                if (interFace.getAttribute(SCAN_PRIORITY) != null) {
                    priority = Integer.parseInt(interFace.getAttribute(SCAN_PRIORITY));
                }
                ArrayList<Capability> capabilties = new ArrayList();
                if (interFace.getChildren(PROVIDES).length > 0) {
                    capabilties = this.retrieveCapabilities(interFace.getChildren(PROVIDES)[0]);
                }
                ITargetInterface instance = (ITargetInterface)interFace.createExecutableExtension("class");
                TargetInterfaceDescription o = new TargetInterfaceDescription(id, instance, capabilties, priority);
                targetInterfaces.put(id, o);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return targetInterfaces;
    }

    public HashMap<String, ITargetAction> getTargetActions() {
        IConfigurationElement[] interfaces;
        HashMap<String, ITargetAction> fActions = new HashMap<String, ITargetAction>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(COM_ATMEL_AVR32_TARGET_INTERFACES);
        IConfigurationElement[] iConfigurationElementArray = interfaces = extensionPoint.getConfigurationElements();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement interFace = iConfigurationElementArray[n2];
            String id = interFace.getAttribute(ID);
            IConfigurationElement[] points = interFace.getChildren(ACTION);
            int count = 0;
            IConfigurationElement[] iConfigurationElementArray2 = points;
            int n3 = points.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray2[n4];
                ++count;
                TargetAction action = null;
                if (element.getAttribute("class") != null) {
                    try {
                        action = (TargetAction)element.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        return fActions;
                    }
                } else {
                    action = element.getChildren(DIALOG).length > 0 ? new TargetDialogAction() : new TargetAction();
                }
                action.setPosition(count);
                if (element.getChildren(DIALOG).length > 0) {
                    IConfigurationElement dialog = element.getChildren(DIALOG)[0];
                    ((TargetDialogAction)action).setComposite(dialog.getAttribute("class"));
                    ((TargetDialogAction)action).setTitle(dialog.getAttribute(TITLE));
                    ((TargetDialogAction)action).setBundleId(interFace.getContributor().getName());
                }
                action.setText(element.getAttribute(LABEL));
                action.setCommand(element.getAttribute(COMMAND));
                action.setDescription(element.getAttribute(TOOLTIP));
                if (element.getAttribute(HELP_CONTEXT_ID) != null) {
                    action.setHelpContextId(element.getAttribute(HELP_CONTEXT_ID));
                }
                if (element.getAttribute(ICON) != null) {
                    ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)element.getAttribute(ICON));
                    action.setImageDescriptor(desc);
                }
                if (element.getAttribute(APPLIES_TO) != null) {
                    try {
                        action.setAppliesTo(ITargetAction.TargetComponent.valueOf(element.getAttribute(APPLIES_TO).toUpperCase()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    action.setAppliesTo(ITargetAction.TargetComponent.MCU);
                }
                if (element.getAttribute(ID) != null) {
                    action.setActionDefinitionId(String.valueOf(id) + "." + element.getAttribute(ID));
                }
                if (element.getChildren(OPTION).length > 0) {
                    ArrayList<String> options = new ArrayList<String>();
                    IConfigurationElement[] iConfigurationElementArray3 = element.getChildren(OPTION);
                    int n5 = iConfigurationElementArray3.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IConfigurationElement option = iConfigurationElementArray3[n6];
                        options.add(option.getAttribute(KEY));
                        if (option.getAttribute(VALUE) != null) {
                            options.add(option.getAttribute(VALUE));
                        }
                        ++n6;
                    }
                    action.setOptions(options.toArray(new String[options.size()]));
                }
                action.setShowResult(element.getAttribute(SHOW_RESULT) != null ? Boolean.parseBoolean(element.getAttribute(SHOW_RESULT)) : false);
                action.setShowProgress(element.getAttribute(SHOW_PROGRESS) != null ? Boolean.parseBoolean(element.getAttribute(SHOW_PROGRESS)) : false);
                action.setSubmenu(element.getAttribute(SUBMENU) != null ? Boolean.parseBoolean(element.getAttribute(SUBMENU)) : false);
                action.setInterfaceId(id);
                if (element.getChildren(REQUIRES).length > 0) {
                    action.setRequirements(this.retrieveCapabilities(element.getChildren(REQUIRES)[0]));
                }
                if (fActions.containsKey(action.getActionDefinitionId())) {
                    TargetPlugin.errorMessage(Messages.InterfaceExtensionPointReader_DuplicateIdError, MessageFormat.format(Messages.InterfaceExtensionPointReader_DuplicateIdErrorMessage, action.getText(), id));
                } else {
                    fActions.put(action.getActionDefinitionId(), action);
                }
                ++n4;
            }
            ++n2;
        }
        return fActions;
    }

    private class Attribute {
        protected String name;
        protected String value;

        private Attribute() {
        }
    }
}

